/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "lcmd/LCmdDlgFileDetails.h"
#include "lcmd/LCmdDlgEAEditor.h"

#include "glib/GProgram.h"
#include "glib/gui/GDialogPanel.h"
#include "glib/gui/event/GDialogMessage.h"
#include "glib/util/GStringUtil.h"

LCmdDlgFileDetails::LCmdDlgFileDetails ( const LCmdFileItem& fitem )
                   :fitem(fitem)
{
}

LCmdDlgFileDetails::~LCmdDlgFileDetails ()
{
}

void LCmdDlgFileDetails::execute ( GWindow* ownerWin )
{
   GProgram& prg = GProgram::GetProgram();
   prg.executeDialog(ownerWin, "DlgFileDetails", this);
}

bool LCmdDlgFileDetails::handleDialogMessage ( GDialogMessage& msg )
{
   GDialogPanel& dlg = msg.getDialog();
   switch (msg.getID())
   {
      case GM_INITDIALOG: 
      {
         // Directory
         dlg.setComponentValue("115", fitem.getDirectory());

         // Filename
         dlg.setComponentValue("116", fitem.getFileName());

         // Attributes
         dlg.setComponentValue("113", fitem.getFileAttributesDescrStr());

         // Created
         dlg.setComponentValue("118", fitem.timeCreate.getDateString());
         dlg.setComponentValue("125", fitem.timeCreate.getTimeString());

         // Last updated
         dlg.setComponentValue("119", fitem.timeWrite.getDateString());
         dlg.setComponentValue("126", fitem.timeWrite.getTimeString());

         // Last accessed
         dlg.setComponentValue("120", fitem.timeAccess.getDateString());
         dlg.setComponentValue("127", fitem.timeAccess.getTimeString());

         // ---
         int fitemInternalFlags = fitem.getInternalFlags();
         bool sizeIsAvail = ((fitemInternalFlags & LCmdFileItem::FINFO_SHOWSIZE) != 0);

         // Size
         GString strSize;
         if (fitem.isDirectory() && !sizeIsAvail)
            strSize = GStringl("%Txt_DlgFileDetails_SizeNotAvailable");
         else
            strSize = GStringUtil::ToByteCountString(fitem.fileSize, true);
         dlg.setComponentValue("121", strSize);

         // Allocated size
         GString strSizeAlloc;
         if (fitem.isDirectory() && !sizeIsAvail)
            strSizeAlloc = GStringl("%Txt_DlgFileDetails_SizeNotAvailable");
         else
            strSizeAlloc = GStringUtil::ToByteCountString(fitem.fileSizeAlloc, true);
         dlg.setComponentValue("122", strSizeAlloc);

         const bool enableEasButton = true;
         dlg.setComponentEnabled("VIEW_EAS", enableEasButton);
         return true; 
      }

      case GM_CLOSEWIN: 
      {
         dlg.dismiss();
         return true; 
      }

      case GM_COMMAND: 
      {
         GString cmdID = msg.getParam1String();
         if (cmdID == "DLG_OK")
            dlg.dismiss();
         else
         if (cmdID == "VIEW_EAS")
            LCmdDlgEAEditor::ShowEAs(&dlg);
         return true; 
      }

      default:
         return false;
   }
}

