/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __LCMD_DLGDEBUGOPTIONS
#define __LCMD_DLGDEBUGOPTIONS

#include "glib/gui/event/GDialogMessageHandler.h"

/**
 * This is the options dilaog shown when user selects the menu-command
 * "Help->Debug->Options...". Among others, it is used for the user to 
 * dynamically change the debug log-level.
 *
 * @author  Leif Erik Larsen
 * @since   2006.10.31
 */
class LCmdDlgDebugOptions : public GDialogMessageHandler
{
private:

   int originalFilterIdx;

public:

   explicit LCmdDlgDebugOptions ();
   virtual ~LCmdDlgDebugOptions ();

public:

   void execute ( class GWindow* ownerWin );

private:

   bool handleDialogMessage ( class GDialogMessage& msg );
};

#endif // #ifndef __LCMD_DLGDEBUGOPTIONS
