/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __LCMD_DLGCOMPAREDIRS
#define __LCMD_DLGCOMPAREDIRS

#include "lcmd/LCmdDirProgressBase.h"

/**
 * This dialog is used by the command "Compare Directories".
 * The command ID is <i>cmdCompareDirs</i>.
 *
 * @since   2000.07.12
 * @author  Leif Erik Larsen
 */
class LCmdDlgCompareDirs : public LCmdDirProgressBase
{
   public:

      /** Used when comparing two directories. */
      enum TAGTIMESTAMPOPT
      {
         TAGTMST_IGNORE = 0,
         TAGTMST_NEWER,
         TAGTMST_OLDER,
         TAGTMST_DIFF
      };

      /** Used when comparing two directories. */
      enum TAGSIZEOPT
      {
         TAGSIZE_IGNORE = 0,
         TAGSIZE_LARGER,
         TAGSIZE_SMALLER,
         TAGSIZE_DIFF
      };

      /** Options used to adjust the way two directories are compared. */
      typedef struct
      {
         /** Choose what timestamp differences to tag. Extended attributes doesn't care. */
         TAGTIMESTAMPOPT timeStampOpt;
         /** Choose what size differences to tag. Extended attributes doesn't care. */
         TAGSIZEOPT sizeOpt;
         /** Choose wether or not unmatched files should be tagged. */
         bool tagUnmatched;
         /** True if contents of files must be equal to match. Extended attributes doesn't care. */
         bool compareContents;
      }
         COMPAREDIRSOPT;

   private:

      COMPAREDIRSOPT* pOpt;
      class LCmdFilePanel& panel1;
      class LCmdFilePanel& panel2;

   public:

      explicit LCmdDlgCompareDirs ( class LCmdFilePanel& panel );
      virtual ~LCmdDlgCompareDirs ();

   private:

      /** Disable the copy constructor. */
      LCmdDlgCompareDirs ( const LCmdDlgCompareDirs& src )
         : LCmdDirProgressBase(src.vfs, null), panel1(src.panel1), panel2(src.panel2) {}

      /** Disable the assignment operator. */
      LCmdDlgCompareDirs& operator= ( const LCmdDlgCompareDirs& ) { return *this; }

   protected:

      /**
       * Perform the comparisation and tagging operation on the
       * specified file item.
       */
      virtual bool handleFileItem ( class LCmdFileItem* pFile, 
                                    int fileIndex, 
                                    bool* bSkipped, 
                                    bool* itemUpdated );

   private:

      /**
       * This is the message handler method that is called to handle
       * messages from the dialog box window.
       */
      bool handleDialogMessage ( class GDialogMessage& msg );

   public:

      /**
       * Create dialog box of where user can edit the Directory
       * Comparisation options. Then, if user doesn't cancel the dialog
       * box, execute the secondary thread of which to perform the
       * directory comparisation.
       */
      void execute ();
};

#endif // #ifndef __LCMD_DLGCOMPAREDIRS
