/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __LCMD_DLGABOUT
#define __LCMD_DLGABOUT

#include "glib/gui/event/GDialogMessageHandler.h"

/**
 * This class forms the definition of the classic About-box.
 *
 * This code is put in its own class because it logically
 * belongs nowhere else. Also this makes it cleaner to
 * implement an "Easter Egg" in it, in case I manage to get the
 * neccessary spare time for it in the future.
 *
 * @since   2000.06.07
 * @author  Leif Erik Larsen
 */
class LCmdDlgAbout : public GDialogMessageHandler
{
   public:

      LCmdDlgAbout ();
      virtual ~LCmdDlgAbout ();

   private:

      /**
       * This is the message handler method that is called to handle
       * messages from the dialog box window.
       */
      bool handleDialogMessage ( class GDialogMessage& msg );

   public:

      /**
       * Execute the modal dialog.
       */
      void execute ( class GWindow* parentWin );

      /**
       * Get a copy of the copyright string of Larsen Commander.
       */
      GString getCopyrightString ();

      /**
       * Get a copy of the current version string of Larsen Commander.
       */
      GString getVersionString ();
};

#endif // #ifndef __LCMD_DLGABOUT
