/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __LCMD_DIRECTORYHISTORY
#define __LCMD_DIRECTORYHISTORY

#include "lcmd/LCmdDlgAbstractCmdHistory.h"

/**
 * The Directory History.
 */
class DirectoryHistory : public LCmdDlgAbstractCmdHistory
{
   public:

      class LCmdCmdLineEntry& entry;

   public:

      DirectoryHistory ( class LCmdCmdLineEntry& entry, int maxNum );
      virtual ~DirectoryHistory ();

   public:

      /**
       * Re-activate the indexed directory.
       *
       * @return   False if the specified index is illegal, or else true.
       */
      bool retrieve ( int index );
};

#endif // #ifndef __LCMD_DIRECTORYHISTORY
