/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __LCMD_CMDCONTAINER
#define __LCMD_CMDCONTAINER

#include "lcmd/LCmdConsoleMonitor.h"
#include "lcmd/LCmdCmdLine.h"

#define MAXCMDHIST 256
#define MAXDIRHIST 128

/**
 * This is the window that forms the parent of all Command Line and
 * Console Monitor components.
 *
 * @author  Leif Erik Larsen
 * @since   1998.10.06
 */
class LCmdCmdContainer : public GWindow
{
   public:

      /** The Console Monitor. */
      LCmdConsoleMonitor conmon;

      /** The Command Line Entry field. */
      LCmdCmdLine cmdline;

   private:

      class LCmdSubClient& parentWin;

   public:

      LCmdCmdContainer ( class LCmdSubClient& parentWin, const GString& constraints );
      virtual ~LCmdCmdContainer ();

   public:

      /**
       * Get the preferred height of the window, in pixels.
       * @see LCmdPanelsParent#getPreferredHeight
       */
      int getPreferredHeight () const;

      /**
       * Load and activate the profile variables for the command container
       * window, from the specified section name.
       * @see #writeProfile
       */
      void queryProfile ( const GString& sectName );

      /**
       * Write the profile variables for the command container window,
       * under the specified section name.
       * @see #queryProfile
       */
      void writeProfile ( const GString& sectName, bool force );
};

#endif // #ifndef __LCMD_CMDCONTAINER
