/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "lcmd/LCmdCmdContainer.h"
#include "lcmd/LCmdSubClient.h"
#include "lcmd/LCmdOptions.h"

#include "glib/GProgram.h"
#include "glib/gui/layout/GBorderLayout.h"

LCmdCmdContainer::LCmdCmdContainer ( LCmdSubClient& parentWin, 
                                     const GString& constraints )
                 :GWindow(&parentWin, 
                          "Console", 
                          constraints, 
                          WS2_IGNORE_COLORS_AND_FONT_PROFILE | WS2_OS2Y),
                  conmon(*this, GBorderLayout::CENTER),
                  cmdline(*this, GBorderLayout::SOUTH, conmon),
                  parentWin(parentWin)
{
   setLayoutManager(new GBorderLayout(), true);
}

LCmdCmdContainer::~LCmdCmdContainer ()
{
}

void LCmdCmdContainer::writeProfile ( const GString& sectName, bool force )
{
   GProgram& prg = GProgram::GetProgram();
   GSectionBag& ini = prg.getIniProperties();
   LCmdOptions& opt = LCmdOptions::GetOptions();
   ini.putInt(sectName, "ConsoleRelHeight", opt.consoleRelHeight, force || opt.saveOnExit.panelModeSort);
   GWindow::writeProfile(sectName, force);
}

void LCmdCmdContainer::queryProfile ( const GString& sectName )
{
   GProgram& prg = GProgram::GetProgram();
   GSectionBag& ini = prg.getIniProperties();
   LCmdOptions& opt = LCmdOptions::GetOptions();
   opt.consoleRelHeight = ini.getInt(sectName, "ConsoleRelHeight", opt.consoleRelHeight);
   GWindow::queryProfile(sectName);
}

int LCmdCmdContainer::getPreferredHeight () const
{
   int ret;

   LCmdOptions& opt = LCmdOptions::GetOptions();
   if (opt.panelsAreVisible)
   {
      if (cmdline.isVisible())
      {
         if (opt.panelsFullScreen)
            ret = cmdline.getPreferredHeight();
         else
            ret = (parentWin.getWindowSize().height * opt.consoleRelHeight) / 1000;
      }
      else
      {
         ret = 0;
      }
   }
   else
   {
      ret = parentWin.getWindowSize().height;
   }

   return ret;
}
