/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_STRINGUTIL
#define __GLIB_STRINGUTIL

#include "glib/primitives/GString.h"

/**
 * This class contains a number of static utility methods for manupulating 
 * analyzing and/or producing strings.
 *
 * @author  Leif Erik Larsen
 * @since   2004.02.09
 */
class GStringUtil : public GObject
{
   private:

      /** Prevent this class from being instantiated. */
      GStringUtil ();

   private:

      static const longlong KILO;
      static const longlong MEGA;
      static const longlong GIGA;
      static const longlong TERA;
      static const GString STR_BYTE0;
      static const GString STR_BYTE1;
      static const GString STR_BYTE2;
      static const GString STR_KILO0;
      static const GString STR_KILO1;
      static const GString STR_KILO2;
      static const GString STR_MEGA0;
      static const GString STR_MEGA1;
      static const GString STR_MEGA2;
      static const GString STR_GIGA0;
      static const GString STR_GIGA1;
      static const GString STR_GIGA2;
      static const GString STR_TERA0;
      static const GString STR_TERA1;
      static const GString STR_TERA2;

   public:

      /**
       * Convert a potential large (many digits) value to a string that is 
       * easy to read by the human eye. That is; thousand separate the 
       * value, and optionally append a byte size unit string to it so
       * that e.g. 1048576 will be "1 MByte".
       *
       * However, if thousandSepOnly is true then we will return a string
       * that represents a pure byte count only, without any "mega" or
       * "kilo" postfix, but with thousand separator characters anyway.
       *
       * @author  Leif Erik Larsen
       * @since   2004.02.05
       * @param   value The value to convert.
       * @param   thousandSepOnly True if we shall only thousand separate
       *                the value without appending any byte size unit.
       * @param   longDescription True if the appended byte size unit
       *                string should be long instead of short.
       *                E.g. "MByte" instead of "M".
       * @param   descrSep True if we shall separate the thousand 
       *                separated value and the trailing description 
       *                with a space character.
       */
      static GString ToByteCountString ( longlong value,
                                         bool thousandSepOnly = false,
                                         bool longDescription = false,
                                         bool descrSep = true );
};

#endif

