/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "glib/util/GEventSemaphore.h"
#include "glib/util/GLog.h"
#include "glib/sys/GSystem.h"
#include "glib/exceptions/GIllegalStateException.h"

GEventSemaphore::GEventSemaphore ()
                :hev(0)
{
   ULONG flags = 0;
   APIRET rc = ::DosCreateEventSem(null, 
                                   &hev, 
                                   flags, 
                                   FALSE); // Initial state.
   if (rc != NO_ERROR)
   {
      hev = null;
      gthrow_(GIllegalStateException(GString("::DosCreateEventSem() returned %d. Message from the system: ", GVArgs(rc).add(GSystem::GetApiRetString(rc)))));
   }
}

GEventSemaphore::~GEventSemaphore ()
{
   if (hev != null)
      ::DosCloseEventSem(hev);
}

int GEventSemaphore::getPostCount () const
{
   ULONG ret = 0;
   ::DosQueryEventSem(hev, &ret);
   return int(ret);
}

void GEventSemaphore::reset ()
{
   ULONG postCount = 0;
   ::DosResetEventSem(hev, &postCount);
}

void GEventSemaphore::wait ()
{
   ::DosWaitEventSem(hev, ULONG(SEM_INDEFINITE_WAIT));
}

void GEventSemaphore::wait ( int timeoutMillis )
{
   ULONG timeOut = ULONG(timeoutMillis <= 0 ? SEM_IMMEDIATE_RETURN : timeoutMillis);
   ::DosWaitEventSem(hev, timeOut);
}

void GEventSemaphore::notifyAll ()
{
   ::DosPostEventSem(hev);
}
