/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_LIBSYS
#define __GLIB_LIBSYS

#define INCL_DOS           // Include Dos...
#define INCL_DOSERRORS     // Include Dos* specific ERROR_...
#define INCL_DOSDEVIOCTL   // DosDevIOCtl()
#define INCL_GPI           // Include Gpi...
#define INCL_GPIERRORS     // Include Gpi* specific PMERR_...
#define INCL_WIN           // Include Win...
#define INCL_WINERRORS     // Include Win* specific PMERR_...
#include <os2.h>
#include <setjmp.h>

// --------------------------------------------------------------------------
// We must be compiled by IBM VisualAge C++ 4.0 for OS/2.
#if defined(__IBMCPP4__)
#define __HAS_KEYWORD_BOOL__ 1
#define __HAS_KEYWORD_MUTABLE__ 1
#define __HAS_FUNCTION_TEMPLATES__ 1
#define __HAS_PLACEMENT_DELETE_OPERATOR__ 1
#define __HAS_ANSI_COMPLIANT_INNER_CLASS_VISIBILITY__ 0
typedef long long longlong;
typedef unsigned long long ulonglong;
#include <typeinfo>   // RTTI.
#include <exception>  // Standard C++ exceptions.
#else
#error Unknown compiler!
#endif

#include "glib/sys/GLibSys_OS2.h"
#define GTHREADENTRY _Optlink
#define GWNDPROCENTRY PFNWP
#define GRECT RECTL

// --------------------------------------------------------------------------
#define null 0
typedef unsigned char byte;

#if __HAS_KEYWORD_MUTABLE__
#define __DECLARE_CONST_SELF__(typeName, varName) const typeName& varName = *this
#else
#define __DECLARE_CONST_SELF__(typeName, varName) typeName& varName = (*(typeName*)this)
#endif

#ifdef GTHROW_NO_LOGGING
/**
 * Since the macro <i>GTHROW_NO_LOGGING</i> is defined then the
 * <i>gthrow_</i> macro will do nothing but throw the exceptin <i>a</i>
 * just as if it was thrown by a native C++ </i>throw</i> statement.
 */
#define gthrow_(a) throw a
#else
/**
 * Use this macro instead of the C++ keyword "throw" when throwing an
 * exception which type is {@link GException} or any of its sub-classes.
 *
 * The thrown exception will be logged by {@link GLog#logForGThrow} including
 * some additional information such as the module name and the line number
 * of where the exception was thrown.
 *
 * To skip this kind of extended logging of exceptions just compile with
 * the macro <i>GTHROW_NO_LOGGING</i> defined, or use the native C++
 * <i>throw</i> keyword to throw a specific exception without this logging.
 *
 * @author  Leif Erik Larsen
 * @since   2000.10.19
 * @see     GException#logForGThrow
 */
#define gthrow_(a)                       \
   {                                      \
      try {                                \
         throw a;                           \
      } catch (GException& e) {              \
         e.logForGThrow(__FILE__, __LINE__);  \
         throw;                                \
      }                                         \
   }
#endif

#endif
