/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_TOOLBARBUTTONPARAMS
#define __GLIB_TOOLBARBUTTONPARAMS

#include "glib/gui/event/GAbstractCommand.h"

/**
 * Each toolbar button is represented with an instance of this class.
 */
class GToolbarButtonParams : public GAbstractCommand
{
   friend class GToolbarResource;

   public:

      /** Different types of toolbar buttons. */
      enum ItemType
      {
         Separator,
         PushButton
      };

      /** ID of icon resource to show on this toolbar button. */
      GString iconID;

      /** Text ID to paint on button (possibly a link to another TEXT). */
      GString textID;

      /** Hint text ID to show as tooltip or hint (possibly a link to another TEXT). */
      GString hintID;

      /** Type of this toolbar button. */
      ItemType itemType;

   private:

      /** True if ICON parameter is defined. */
      bool isIconDef;

      /** True if TEXT parameter is defined. */
      bool isTextDef;

      /** True if HINT parameter is defined. */
      bool isHintDef;

      /** True if USERDATA parameter is defined. */
      bool isUserDataDef;

   public:

      explicit GToolbarButtonParams ( const GString& id );

   private:

      GToolbarButtonParams ();

   public:

      /**
       * @author  Leif Erik Larsen
       * @since   2000.09.08
       * @param   tokenizer The tokenizer of where to get tokens to parse.
       * @param   table     The resource table of where to lookup referenced 
       *                    resources such as e.g. icons and texts.
       * @throws  GRcException in case of any error.
       */
      virtual void loadFromScript ( class GRcTokenizer& tokenizer, 
                                    class GResourceTable* table );
};

#endif

