/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_RCEXCEPTION
#define __GLIB_RCEXCEPTION

#include "glib/primitives/GVArgs.h"
#include "glib/exceptions/GException.h"

/**
 * This exception is thrown by the resource script compiler/parser
 * in case of any syntax error or other script related errors such as
 * include-module not found, etc.
 *
 * @author  Leif Erik Larsen
 * @since   2000.08.30
 * @see     GRcCompiler
 */
class GRcException : public GException
{
   public:

      enum ERRORCODES
      {
         ERR_UNKNOWN = 0,        /* Unknown error */
         ERRSRCFNFOUND,          /* Can't find source file: %s */
         ERRSYNTAXERROR,         /* Syntax error! */
         ERRUNCLOSEDCOMT,        /* Unclosed comment at EOF! */
         ERRUNCLOSEDIFELSE,      /* Unclosed #IF or #ELSE at EOF! */
         ERRUNTERMSTRING,        /* Unterminated string! */
         ERROPENDESTFILE,        /* Failed on open destination file */
         ERRINCFNFOUND,          /* Can't find #include file: %s */
         ERRLFNFOUND,            /* Can't find any match to logical filename: %s */
         ERRWUNKNOWN,            /* Unknown token: %s */
         ERRUNKNOWNOPER,         /* Unknown operator: %s */
         ERRUNKNOWNSYMBOL,       /* Unknown symbol: %s */
         ERRWRITEF,              /* Failed on write to destination file */
         ERR_EXPECTED_X_FOUND_Y, /* Expected '%1' but found '%2' in statement! */
         ERRIDINSEPRT,           /* Can't define an ID to a SEPARATOR! */
         ERRKEYINPOPUP,          /* Can't define a shortcut to a POPUP or SEPARATOR */
         ERRUNKNOWNKEY,          /* Unknown shortcut KEY: %s */
         ERRINVISBLSEP,          /* Can't define a SEPARATOR as INVISIBLE */
         ERRUSERLEVOUTOFRNG,     /* Specified User Level Out Of Range. Must be 1-9. */
         ERRDISABLDSEP,          /* Can't define a SEPARATOR as DISABLED */
         ERRITEMMISSID,          /* No ID specified for this ITEM */
         ERRITEMMISSTEXT,        /* No TEXT specified for this POPUP/ITEM! */
         ERROUTOFMNTXT,          /* No more free items for TEXTS */
         ERRMENTXTDEFD,          /* Specified TEXT ID already defined: %s */
         ERRICONDEFD,            /* Specified ICON ID already defined: %s */
         ERRMENUDEFD,            /* Specified MENU ID already defined: %s */
         ERRTBARDEFD,            /* Specified TOOLBAR ID already defined: %s */
         ERRDIALOGDEFD,          /* Specified DIALOG ID already defined: %s */
         ERRACCELDEFD,           /* Specified ACCELTABLE ID already defined: %s */
         ERRMENTXTNOID,          /* No ID-parameter specified for this TEXT */
         ERRMENTXTNOTXT,         /* No TEXT-parameter specified for this TEXT */
         ERRWIDTHLTHAN0,         /* WIDTH must be larger than zero! */
         ERRHEIGHTLTHAN0,        /* HEIGHT must be larger than zero! */
         ERRILLEGCOLBITS,        /* Illegal number of COLORBITS! */
         ERRPIXELSWOWH,          /* Can't define PIXELS before WIDTH and HEIGHT. */
         ERRNOPIXELS,            /* Icon '%s' contains none PIXELS! */
         ERRNROFPIXELS,          /* Illegal number of PIXELS defined in icon '%s'! */
         ERRUNKNOWDIREC,         /* Unknown preprocessor directive: %s */
         ERRPIXELSARDEF,         /* PIXELS already defined! */
         ERRCOLBITSARDEF,        /* COLORBITS already defined! */
         ERRHEIGHTARDEF,         /* HEIGHT already defined! */
         ERRWIDTHARDEF,          /* WIDTH already defined! */
         ERRIDARDEF,             /* ID already defined! */
         ERRICONARDEF,           /* ICON already defined! */
         ERRLAYOUTARDEF,         /* LAYOUT already defined! */
         ERRUSERDATA1ARDEF,      /* Userdata already defined! */
         ERRTEXTARDEF,           /* TEXT already defined! */
         ERRKEYARDEF,            /* KEY already defined! */
         ERRNOKEYDEF,            /* No KEY defined! */
         ERRACCELARDEF,          /* The specified key combination is already defined! */
         ERRHINTARDEF,           /* HINT already defined! */
         ERRACCELTABLEARDEF,     /* ACCELTABLE already defined! */
         ERRMENUARDEF,           /* MENU already defined! */
         ERRTOOLBARARDEF,        /* TOOLBAR already defined! */
         ERRXPOSARDEF,           /* XPOS already defined! */
         ERRYPOSARDEF,           /* YPOS already defined! */
         ERRNEXTARDEF,           /* NEXT already defined! */
         ERRPREVARDEF,           /* PREVIOUS already defined! */
         ERRFNEXTARDEF,          /* FORCENEXT already defined! */
         ERRFPREVARDEF,          /* FORCEPREVIOUS already defined! */
         ERRUNDEFICON,           /* Undefined ICON: '%s' */
         ERRUNDEFACCEL,          /* Undefined ACCELTABLE: '%s' */
         ERRUNDEFMENU,           /* Undefined MENU: '%s' */
         ERRUNDEFTOOLBAR,        /* Undefined TOOLBAR: '%s' */
         ERRUNKNOWNCTRL,         /* Unknown type of control: '%s'! */
         ERR2CTRLSSAMEID,        /* Control '%s' is defined twice in dialog '%s'! */
         ERRITEMMISSIDTB,        /* No ID specified for this toolbar button! */
         ERRITEMMISSTEXTTB,      /* No TEXT specified for this toolbar button! */
         ERRENVDLGCTRLSND,       /* Environment variable %s is undefined! */
         ERROPENDLGCTRLS,        /* Failed on open %%%s%% to read list of supported dialog controls! */
         ERRDLGCTRLSSYNTXERR,    /* Syntax error in %%%s%% line number %d! */
         ERRDLGCTRLSTOMANY,      /* To many controls in %%%s%%. Max is %d! */
         ERRTOMANYIFLEVELS,      /* To many levels of nested #IF/#IFDEF directives! Max is %d. */
         ERRELSEWITHOUTIF,       /* #ELSE without #IF */
         ERRENDIFWITHOUTIF,      /* #ENDIF without #IF */
         ERRUNEXPECTEDEOS,       /* Unexpected End-Of-Stream! */
         ERRERRORDIRECTIVE,      /* %s */
         ERRSYMALREADYDEFINED,   /* Symbol already defined: %s */
         ERRCANTMIXTYPES,        /* Can't mix values of type %s and %s in expression! */
         ERREXPECTEDINTEGER,     /* Expected an INTEGER, but found %s. */
         ERREXPECTEDFLOAT,       /* Expected a FLOAT, but found %s. */
         ERRINCMUSTBEQUOTED,     /* #INCLUDE... module must be inside a pair of quotes! */
         ERRTXTARDEFALT1,        /* ALT1 Already defined! */
         ERRTXTARDEFALT2,        /* ALT2 Already defined! */
         ERRTXTARDEFALT3,        /* ALT3 Already defined! */
         ERRTXTARDEFALT4,        /* ALT4 Already defined! */
         ERRTXTARDEFALT5,        /* ALT5 Already defined! */
         ERRTXTARDEFALT6,        /* ALT6 Already defined! */
         ERRTXTARDEFALT7,        /* ALT7 Already defined! */
         ERRTXTARDEFALT8,        /* ALT8 Already defined! */
         ERRTXTARDEFALT9,        /* ALT9 Already defined! */
         ERRPALBEFORECOLBITS,    /* Can't define PALETTE before COLORBITS. */
         ERRPALNOTNEEDEDRGB,     /* PALETTE not needed for RGB color mode icons. */
         ERRPALBEFOREPIXELS,     /* PALETTE must come before PIXELS. */
         ERRPALETTEARDEF,        /* PALETTE already defined. */
         ERRINVPALETTESIZE,      /* Invalid PALETTE size. */
         ERRNOTHEXINT,           /* Not a hexadecimal integer: "%s". */
         ERR_NR                  /* Let us know the number of available error codes */
      };

   private:

      struct ErrorMsg
      {
         ERRORCODES errCode;
         const char* errMsg;
      };

      static ErrorMsg ErrMessages[];

   private:

      GRcException::ERRORCODES errCode;

   public:

      /**
       * Create a new resource script exception with the specified error
       * code and formatted message string.
       *
       * @author  Leif Erik Larsen
       * @since   2000.08.30
       * @param   rc   Reference to the owner resource tokenizer.
       * @param   err  Error code of specified error message. This is the
       *               index of which error message string to display.
       * @param   ...  Variable argument list, formatted by the error message
       *               string which is indexed by iErr.
       */
      GRcException ( const class GRcTokenizer& rc, 
                     ERRORCODES err, 
                     const GVArgs& args = GVArgs() );

      /**
       * Use this constructor if you want to override the message string with the
       * specified <i>msg</i> instead of the default message string that would
       * else come from the specified error code.
       *
       * @author  Leif Erik Larsen
       * @since   2000.09.07
       */
      GRcException ( const class GRcTokenizer& rc, 
                     const GString msg, 
                     ERRORCODES err );

   private:

      /**
       * Common construction code.
       */
      void init ( const class GRcTokenizer& rc, const GString& msg );

   public:

      /**
       * Get the error code of this exception.
       */
      GRcException::ERRORCODES getErrorCode () const;
};

#endif


