/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_RCCOMPILER
#define __GLIB_RCCOMPILER

#include "glib/resource/GRcTokenizer.h"
#include "glib/resource/GResourceTable.h"

/**
 * This is the resource compiler class.
 *
 * This compiler can handle all types of G-lib resources;
 * texts, icons, menues, dialogs and toolbars.
 *
 * @author  Leif Erik Larsen
 * @since   1999.03.07
 */
class GRcCompiler
{
   private:

      /**
       * Prevent instantiation, since all methods of this class are static.
       */
      GRcCompiler () {}

   public:

      /**
       * Main entry point of the resource script compiler.
       *
       * @author Leif Erik Larsen
       * @since  2000.09.07
       * @param  tokenizer   The tokenizer of where to get tokens to parse.
       * @return A new instance of a {@link GResourceTable} containging all
       *         the compiled and loaded resources.
       * @throws GRcException in case of any error.
       */
      static aptr<GResourceTable> ParseResources ( GRcTokenizer& tokenizer );

      /**
       * Parse the next resource taken from the tokenizer stream,
       * and put it into the given resource table.
       *
       * @author  Leif Erik Larsen
       * @since   2000.09.08
       * @return  The new and loaded resource or null if end of stream.
       *          Note that the ownership of the returned object belongs
       *          to the resource table and not directly to the caller.
       * @throws  GRcException in case of any error.
       */
      static GAbstractResource* ParseResource ( GRcTokenizer& tokenizer, GResourceTable& table );
};

#endif


