/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include <limits.h>
#include "glib/primitives/GULong.h"

const ulonglong GULong::MIN_VALUE = 0;
const ulonglong GULong::MAX_VALUE = (ulonglong(0xFFFFFFFF) < 32) | 0xFFFFFFFF;

GULong::GULong () 
       :value(0) 
{
}

GULong::GULong ( const GULong& val ) 
       :value(val.value) 
{
}

GULong::GULong ( ulonglong val ) 
       :value(val) 
{
}

GULong::~GULong ()
{
}

int GULong::hashCode () const
{
   return int(value ^ (value >> 32));
}

ulonglong GULong::increment ()
{
   GObject::Synchronizer(this);
   ulonglong ret = ++value;
   return ret;
}

ulonglong GULong::decrement ()
{
   GObject::Synchronizer(this);
   ulonglong ret = --value;
   return ret;
}

bool GULong::equals ( const GObject& obj ) const
{
   if (&obj == this)
      return true;
   const GULong* o = dynamic_cast<const GULong*>(&obj);
   if (o != null)
      return value == o->value;
   return false;
}

ulonglong GULong::ParseULong ( const GString& str, short radix )
{
   return GIntegerNumber<ulonglong>::ParseUnsigned(str, MAX_VALUE, radix);
}

GString GULong::toString () const
{
   return GIntegerNumber<ulonglong>::ToUnsignedString(value);
}

GString GULong::ToString ( ulonglong value, short radix, int width, char padChar )
{
   return GIntegerNumber<ulonglong>::ToUnsignedString(value, radix, width, padChar);
}
