/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_FLOATNUMBER
#define __GLIB_FLOATNUMBER

#include "glib/primitives/GNumber.h"

/**
 * This is the abstract base class for every class that is
 * used to wrap a primitive integer number, such as e.g. GShort,
 * GInteger and GLong.
 *
 * @author  Leif Erik Larsen
 * @since   2000.10.23
 */
class GFloatNumber : public GNumber
{
   protected:

      GFloatNumber ();
      GFloatNumber ( const GFloatNumber& src );

      virtual ~GFloatNumber ();

   public:

      /**
       * A default implementation of object comparization that 
       * works on all subclasses of {@link GFloatNumber}. It uses the
       * values returned by {@link GNumber#doubleValue}.
       *
       * @author  Leif Erik Larsen
       * @since   2004.03.14
       * @param   obj  The object of which to compare to.
       *               Must be an instance of {@link GNumber}.
       * @see     GArrayImpl#compare2Objects
       * @see     GComparator
       */
      virtual int compareObj ( const GObject& obj ) const;
};

#endif


