/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_KEY
#define __GLIB_KEY

#include "glib/primitives/GObject.h"

/**
 * This class is just an interface that contains the definition of
 * a large number of constants that are used by <i>GKeyMessage</i> to
 * identify various keyboard codes in a way that is extreemely easy to
 * use by program code for a lot of common situations.
 *
 * @author  Leif Erik Larsen
 * @since   2000.01.26
 * @see     GKeyMessage
 */
class GKey
{
   // Some of the constants defined in {@link GKey} are known to possibly
   // conflict with some dangerous define's in system dependent headers.
   // Thus, we are better undefining them here, before redefining them
   // later in the {@link GKey} class.
   #ifdef UNKNOWN
   #undef UNKNOWN
   #endif
   #ifdef DELETE
   #undef DELETE
   #endif

   public:

      enum KeyCode
      {
         KEY_UNKNOWN,

         KEY_ENTER, KEY_ESCAPE,
         KEY_SPACE, KEY_BACKSPACE,
         KEY_TABULATOR,
         KEY_F1, KEY_F2, KEY_F3,
         KEY_F4, KEY_F5, KEY_F6,
         KEY_F7, KEY_F8, KEY_F9,
         KEY_F10, KEY_F11, KEY_F12,
         KEY_UP, KEY_DOWN,
         KEY_LEFT, KEY_RIGHT,
         KEY_INSERT, KEY_DELETE,
         KEY_HOME, KEY_END,
         KEY_PAGEUP, KEY_PAGEDOWN,
         KEY_A, KEY_B, KEY_C, KEY_D, KEY_E,
         KEY_F, KEY_G, KEY_H, KEY_I, KEY_J,
         KEY_K, KEY_L, KEY_M, KEY_N, KEY_O,
         KEY_P, KEY_Q, KEY_R, KEY_S, KEY_T,
         KEY_U, KEY_V, KEY_W, KEY_X, KEY_Y, KEY_Z,
         KEY_0, KEY_1, KEY_2, KEY_3, KEY_4,
         KEY_5, KEY_6, KEY_7, KEY_8, KEY_9,

         // ALT
         KEY_ALT_ENTER, KEY_ALT_ESCAPE,
         KEY_ALT_SPACE, KEY_ALT_BACKSPACE,
         KEY_ALT_TABULATOR,
         KEY_ALT_F1, KEY_ALT_F2, KEY_ALT_F3,
         KEY_ALT_F4, KEY_ALT_F5, KEY_ALT_F6,
         KEY_ALT_F7, KEY_ALT_F8, KEY_ALT_F9,
         KEY_ALT_F10, KEY_ALT_F11, KEY_ALT_F12,
         KEY_ALT_UP, KEY_ALT_DOWN,
         KEY_ALT_LEFT, KEY_ALT_RIGHT,
         KEY_ALT_INSERT, KEY_ALT_DELETE,
         KEY_ALT_HOME, KEY_ALT_END,
         KEY_ALT_PAGEUP, KEY_ALT_PAGEDOWN,
         KEY_ALT_A, KEY_ALT_B, KEY_ALT_C, KEY_ALT_D, KEY_ALT_E,
         KEY_ALT_F, KEY_ALT_G, KEY_ALT_H, KEY_ALT_I, KEY_ALT_J,
         KEY_ALT_K, KEY_ALT_L, KEY_ALT_M, KEY_ALT_N, KEY_ALT_O,
         KEY_ALT_P, KEY_ALT_Q, KEY_ALT_R, KEY_ALT_S, KEY_ALT_T,
         KEY_ALT_U, KEY_ALT_V, KEY_ALT_W, KEY_ALT_X, KEY_ALT_Y, KEY_ALT_Z,
         KEY_ALT_0, KEY_ALT_1, KEY_ALT_2, KEY_ALT_3, KEY_ALT_4,
         KEY_ALT_5, KEY_ALT_6, KEY_ALT_7, KEY_ALT_8, KEY_ALT_9,

         // SHIFT
         KEY_SHIFT_ENTER, KEY_SHIFT_ESCAPE,
         KEY_SHIFT_SPACE, KEY_SHIFT_BACKSPACE,
         KEY_SHIFT_TABULATOR,
         KEY_SHIFT_F1, KEY_SHIFT_F2, KEY_SHIFT_F3,
         KEY_SHIFT_F4, KEY_SHIFT_F5, KEY_SHIFT_F6,
         KEY_SHIFT_F7, KEY_SHIFT_F8, KEY_SHIFT_F9,
         KEY_SHIFT_F10, KEY_SHIFT_F11, KEY_SHIFT_F12,
         KEY_SHIFT_UP, KEY_SHIFT_DOWN,
         KEY_SHIFT_LEFT, KEY_SHIFT_RIGHT,
         KEY_SHIFT_INSERT, KEY_SHIFT_DELETE,
         KEY_SHIFT_HOME, KEY_SHIFT_END,
         KEY_SHIFT_PAGEUP, KEY_SHIFT_PAGEDOWN,
         KEY_SHIFT_A, KEY_SHIFT_B, KEY_SHIFT_C, KEY_SHIFT_D, KEY_SHIFT_E,
         KEY_SHIFT_F, KEY_SHIFT_G, KEY_SHIFT_H, KEY_SHIFT_I, KEY_SHIFT_J,
         KEY_SHIFT_K, KEY_SHIFT_L, KEY_SHIFT_M, KEY_SHIFT_N, KEY_SHIFT_O,
         KEY_SHIFT_P, KEY_SHIFT_Q, KEY_SHIFT_R, KEY_SHIFT_S, KEY_SHIFT_T,
         KEY_SHIFT_U, KEY_SHIFT_V, KEY_SHIFT_W, KEY_SHIFT_X, KEY_SHIFT_Y, KEY_SHIFT_Z,
         KEY_SHIFT_0, KEY_SHIFT_1, KEY_SHIFT_2, KEY_SHIFT_3, KEY_SHIFT_4,
         KEY_SHIFT_5, KEY_SHIFT_6, KEY_SHIFT_7, KEY_SHIFT_8, KEY_SHIFT_9,

         // CTRL
         KEY_CTRL_ENTER, KEY_CTRL_ESCAPE,
         KEY_CTRL_SPACE, KEY_CTRL_BACKSPACE,
         KEY_CTRL_TABULATOR,
         KEY_CTRL_F1, KEY_CTRL_F2, KEY_CTRL_F3,
         KEY_CTRL_F4, KEY_CTRL_F5, KEY_CTRL_F6,
         KEY_CTRL_F7, KEY_CTRL_F8, KEY_CTRL_F9,
         KEY_CTRL_F10, KEY_CTRL_F11, KEY_CTRL_F12,
         KEY_CTRL_UP, KEY_CTRL_DOWN,
         KEY_CTRL_LEFT, KEY_CTRL_RIGHT,
         KEY_CTRL_INSERT, KEY_CTRL_DELETE,
         KEY_CTRL_HOME, KEY_CTRL_END,
         KEY_CTRL_PAGEUP, KEY_CTRL_PAGEDOWN,
         KEY_CTRL_A, KEY_CTRL_B, KEY_CTRL_C, KEY_CTRL_D, KEY_CTRL_E,
         KEY_CTRL_F, KEY_CTRL_G, KEY_CTRL_H, KEY_CTRL_I, KEY_CTRL_J,
         KEY_CTRL_K, KEY_CTRL_L, KEY_CTRL_M, KEY_CTRL_N, KEY_CTRL_O,
         KEY_CTRL_P, KEY_CTRL_Q, KEY_CTRL_R, KEY_CTRL_S, KEY_CTRL_T,
         KEY_CTRL_U, KEY_CTRL_V, KEY_CTRL_W, KEY_CTRL_X, KEY_CTRL_Y, KEY_CTRL_Z,
         KEY_CTRL_0, KEY_CTRL_1, KEY_CTRL_2, KEY_CTRL_3, KEY_CTRL_4,
         KEY_CTRL_5, KEY_CTRL_6, KEY_CTRL_7, KEY_CTRL_8, KEY_CTRL_9,

         // SHIFT+CTRL
         KEY_SHIFT_CTRL_ENTER, KEY_SHIFT_CTRL_ESCAPE,
         KEY_SHIFT_CTRL_SPACE, KEY_SHIFT_CTRL_BACKSPACE,
         KEY_SHIFT_CTRL_TABULATOR,
         KEY_SHIFT_CTRL_F1, KEY_SHIFT_CTRL_F2, KEY_SHIFT_CTRL_F3,
         KEY_SHIFT_CTRL_F4, KEY_SHIFT_CTRL_F5, KEY_SHIFT_CTRL_F6,
         KEY_SHIFT_CTRL_F7, KEY_SHIFT_CTRL_F8, KEY_SHIFT_CTRL_F9,
         KEY_SHIFT_CTRL_F10, KEY_SHIFT_CTRL_F11, KEY_SHIFT_CTRL_F12,
         KEY_SHIFT_CTRL_UP, KEY_SHIFT_CTRL_DOWN,
         KEY_SHIFT_CTRL_LEFT, KEY_SHIFT_CTRL_RIGHT,
         KEY_SHIFT_CTRL_INSERT, KEY_SHIFT_CTRL_DELETE,
         KEY_SHIFT_CTRL_HOME, KEY_SHIFT_CTRL_END,
         KEY_SHIFT_CTRL_PAGEUP, KEY_SHIFT_CTRL_PAGEDOWN,
         KEY_SHIFT_CTRL_A, KEY_SHIFT_CTRL_B, KEY_SHIFT_CTRL_C, KEY_SHIFT_CTRL_D, KEY_SHIFT_CTRL_E,
         KEY_SHIFT_CTRL_F, KEY_SHIFT_CTRL_G, KEY_SHIFT_CTRL_H, KEY_SHIFT_CTRL_I, KEY_SHIFT_CTRL_J,
         KEY_SHIFT_CTRL_K, KEY_SHIFT_CTRL_L, KEY_SHIFT_CTRL_M, KEY_SHIFT_CTRL_N, KEY_SHIFT_CTRL_O,
         KEY_SHIFT_CTRL_P, KEY_SHIFT_CTRL_Q, KEY_SHIFT_CTRL_R, KEY_SHIFT_CTRL_S, KEY_SHIFT_CTRL_T,
         KEY_SHIFT_CTRL_U, KEY_SHIFT_CTRL_V, KEY_SHIFT_CTRL_W, KEY_SHIFT_CTRL_X, KEY_SHIFT_CTRL_Y, KEY_SHIFT_CTRL_Z,
         KEY_SHIFT_CTRL_0, KEY_SHIFT_CTRL_1, KEY_SHIFT_CTRL_2, KEY_SHIFT_CTRL_3, KEY_SHIFT_CTRL_4,
         KEY_SHIFT_CTRL_5, KEY_SHIFT_CTRL_6, KEY_SHIFT_CTRL_7, KEY_SHIFT_CTRL_8, KEY_SHIFT_CTRL_9
      };
};

#endif


