/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "glib/gui/event/GCommandMap.h"
#include "glib/gui/GTooltip.h"
#include "glib/primitives/GInteger.h"
#include "glib/util/GLog.h"

GMenuCommandImpl::GMenuCommandImpl ( const GString& cmdID ) 
                 :GAbstractCommand(cmdID)
{
}

GMenuCommandImpl::~GMenuCommandImpl () 
{
}

GMenuCommandBagImpl::GMenuCommandBagImpl () 
{
}

GMenuCommandBagImpl::~GMenuCommandBagImpl ()
{
}

void GMenuCommandBagImpl::closeTooltip () const 
{ 
   GTooltip::Hide(); 
} 

GCommandMap::GCommandMap ()
            :mapBag(32),
             idMapByIDString(32)
{
}

GCommandMap::~GCommandMap ()
{
}

void GCommandMap::addCommand ( int id, GMenuPopupItem* item )
{
   GString buff = GInteger::ToString(id);
   mapBag.put(buff, item, false);
   const GString& idStr = item->getIDString();
   if (idStr != "")
   {
      GInteger* ival = new GInteger(id);
      idMapByIDString.put(idStr, ival);
   }
}

GMenuPopupItem* GCommandMap::getCommand ( int id )
{
   GString idStr = GInteger::ToString(id);
   return mapBag.get(idStr);
}

int GCommandMap::getCommandMapID ( const char* commandID )
{
   if (commandID == null)
      return -1;

   GInteger* val = idMapByIDString.get(commandID);
   if (val != null)
      return *val;
   else
      return -1;
}

