/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "glib/gui/border/GLineBorder.h"
#include "glib/gui/GGraphics.h"
#include "glib/primitives/GInsets.h"
#include "glib/exceptions/GIllegalArgumentException.h"

GLineBorder::GLineBorder ( Align alignAll )
            :topAlign(alignAll),
             bottomAlign(alignAll),
             leftAlign(alignAll),
             rightAlign(alignAll),
             bckColor(null),
             lineColor(null)
{
}

GLineBorder::GLineBorder ( Align topAlign,
                           Align bottomAlign,
                           Align leftAlign,
                           Align rightAlign )
            :topAlign(topAlign),
             bottomAlign(bottomAlign),
             leftAlign(leftAlign),
             rightAlign(rightAlign),
             bckColor(null),
             lineColor(null)
{
}

GLineBorder::~GLineBorder ()
{
   delete bckColor;
   delete lineColor;
}

void GLineBorder::setBackgroundColor ( const GColor& color )
{
   if (bckColor != null)
      delete bckColor;
   bckColor = new GColor(color);
}

void GLineBorder::setLineColor ( const GColor& color )
{
   if (lineColor != null)
      delete lineColor;
   lineColor = new GColor(color);
}

void GLineBorder::paintTheBorder ( GGraphics& g,
                                   const GRectangle& rect, 
                                   const GInsets& ins ) const
{
   if (bckColor != null)
      g.setColor(*bckColor);
   paintBackGround(g);
   g.setLineType(GGraphics::LTSolid);
   if (lineColor != null)
      g.setColor(*lineColor);
   else
      g.setColor(GColor::DGRAY); // TODO: Fixed default line color should be customizable.

   // Calculate leftX.
   int leftX = rect.x;
   if (leftAlign == AlignInner)
      leftX += ins.left - 1;
   else
   if (leftAlign == AlignCenter)
      leftX += (ins.left / 2);

   // Calculate rightX.
   int rightX = rect.x + rect.width - 1;
   if (rightAlign == AlignInner)
      rightX -= ins.right - 1;
   else
   if (rightAlign == AlignCenter)
      rightX -= (ins.right / 2);

   // Calculate bottomY.
   int bottomY = rect.y;
   if (bottomAlign == AlignInner)
      bottomY += ins.bottom - 1;
   else
   if (bottomAlign == AlignCenter)
      bottomY += (ins.bottom / 2);

   // Calculate topY.
   int topY = rect.y + rect.height - 1;
   if (topAlign == AlignInner)
      topY -= ins.top - 1;
   else
   if (topAlign == AlignCenter)
      topY -= (ins.top / 2);

   // Draw the top thin line.
   if (ins.top > 0 && topAlign != AlignInvisible)
      g.drawLine(leftX, topY, rightX + 1, topY);

   // Draw the bottom thin line.
   if (ins.bottom > 0 && bottomAlign != AlignInvisible)
      g.drawLine(leftX, bottomY, rightX + 1, bottomY);

   // Draw the left thin line.
   if (ins.left > 0 && leftAlign != AlignInvisible)
      g.drawLine(leftX, bottomY, leftX, topY + 1);

   // Draw the right thin line.
   if (ins.left > 0 && rightAlign != AlignInvisible)
      g.drawLine(rightX, bottomY, rightX, topY + 1);
}
