/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_TOOLBAR
#define __GLIB_TOOLBAR

#include "glib/gui/GAbstractToolbarWindow.h"

/**
 * @author  Leif Erik Larsen
 * @since   2001.03.07
 */
class GToolbar : public GAbstractToolbarWindow
{
   public:

      GToolbar ( const GString& name,
                 const GString& constraints,
                 GWindow& parentWin,
                 const GString& resourceID );

      virtual ~GToolbar ();

   private:

      /** Disable the copy constructor. */
      GToolbar ( const GToolbar& src ) 
         : GAbstractToolbarWindow(GString::Empty, GString::Empty, *this) {}

      /** Disable the assignment operator. */
      GToolbar& operator= ( const GToolbar& ) { return *this; }

   public:

      /**
       * Get the preferred height of the toolbar window, in pixels.
       */
      virtual int getPreferredHeight () const;

      /**
       * Get the preferred width of the toolbar window, in pixels.
       */
      virtual int getPreferredWidth () const;

      virtual void layout ();
};

#endif
