/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "glib/gui/GStaticIcon.h"
#include "glib/gui/GGraphics.h"
#include "glib/util/GMath.h"
#include "glib/util/GLog.h"
#include "glib/resource/GIconResource.h"

GStaticIcon::GStaticIcon ( const GString& name,
                           const GString& constraints,
                           GWindow& parentWin,
                           const GString& iconName,
                           long winStyle,
                           long winStyle2 )
            :GWindow(name,
                     constraints,
                     &parentWin,
                     &parentWin,
                     winStyle,
                     winStyle2 | WS2_OS2Y),
             iconName(iconName)
{
}

GStaticIcon::~GStaticIcon ()
{
}

bool GStaticIcon::onPaintBackground ( GGraphics& g, const GRectangle& rect )
{
   GColor bck = getBackgroundColor();
   g.setColor(bck);
   g.drawFilledRectangle(rect);
   return true;
}

bool GStaticIcon::onPaint ( GGraphics& g, const GRectangle& /*rect*/ )
{
   const GIcon* icon = getIcon();
   if (icon == null)
      return true;

   GRectangle r = getWindowRect();

   // Calculate horizontal and vertical centered icon position.
   int xpos = GMath::Max(0, r.x + (r.width/2) - (icon->getWidth()/2) - 1);
   int ypos = GMath::Max(0, r.y + (r.height/2) - (icon->getHeight()/2) - 1);

   // Paint the icon.
   if (icon != null)
      g.drawIcon(xpos, ypos, *icon);
   return true;
}

const GIcon* GStaticIcon::getIcon () const 
{ 
   bool grayed = !isEnabled();
   return GIcon::GetIcon(iconName, grayed);
}

bool GStaticIcon::setIcon ( const GString& iconName )
{
   this->iconName = iconName;
   invalidateAll(false);
   bool grayed = !isEnabled();
   const GIcon* icon = GIcon::GetIcon(iconName, grayed);
   return icon != null;
}
