/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_MENUPOPUPITEM
#define __GLIB_MENUPOPUPITEM

#include "glib/resource/GMenuItemParams.h"
#include "glib/gui/GIcon.h"

/**
 * @author  Leif Erik Larsen
 * @since   2001.03.07
 */
class GMenuPopupItem : public GAbstractCommand
{
   friend class GMenuPopup;

   private:

      /** The menu item ID as is seen by the underlying system. */
      int sysID;

   public:

      /** Text of the item (not an ID of the text). */
      GString text;

      /** Hint of the item (not an ID of the text). */
      GString hint;

      /** The icon resource, or NULL if no icon. */
      const GIcon* icon;

      /** ID of which accelerator's key to display in menu. */
      GString accelKeyID;

      /** Index of mnemonic character in textID. No mnemonic if -1. */
      int mnemonicChar;

      /** ITEM, POPUP or SEPARATOR. */
      GMenuItemParams::Type iType;

      /** Reference to which menu window owns us. */
      class GMenuPopup& ownerMenu;

      /** Pointer to sub-popup, if door to a new popup level. Or else null. */
      class GMenuPopup* subPopup;

   public:

      GMenuPopupItem ( class GMenuPopup& ownerMenu,
                       GMenuItemParams& mi,
                       int sysID );

   public:

      /** 
       * Get the menu item ID that is used by the underlying system.
       */
      int getSysID () const;

      /**
       * If the item currently has an active mnemonic character then
       * return that character. Else return zero.
       */
      char getMnemonicChar () const;

      /**
       * Get the full text of the menu item to be used in case the menu
       * item is to be painted by the underlying system. That is if the
       * menu is painted with the "fancy style".
       *
       * The returned string will include the keybord code specification
       * (if any) as well as the mnemonic marker character tag.
       */
      GString getSystemText () const;
};

#endif

