/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_MENU
#define __GLIB_MENU

#include "glib/gui/GMenuPopup.h"
#include "glib/gui/event/GCommandMap.h"

/**
 * Menubars and top-level poup-menues will be an instance of this class.
 *
 * @author  Leif Erik Larsen
 * @since   2001.03.07
 */
class GMenu : public GMenuPopup
{
   friend class GMenuPopup;
   friend class GMenuPopup::TheWindow;

   private:

      int commandIDCounter;
      bool useFancyMenues;
      bool is_Menubar;
      GCommandMap commandMap;

   public:

      /**
       * @param  name           .
       * @param  parentWin      Window of where to send <i>msgID</i> message
       *                        when menu item has been selected.
       * @param  msgID          Which message ID to send to <i>parentWin</i>
       *                        when user has selected a menu item.
       * @param  popup          The menu resource it self, of which to
       *                        use as the template.
       * @param  useFancyMenues .
       * @param  isMenuBar      .
       * @param  topMnemonicsOn .
       */
      GMenu ( const GString& name,
              const GString& constraints,
              GWindow& parentWin,
              GMenuPopupParams* popup,
              bool useFancyMenues,
              bool isMenuBar,
              bool topMnemonicsOn = true );

      virtual ~GMenu ();

   private:

      /** Disable the copy constructor. */
      GMenu ( const GMenu& src ) 
         : GMenuPopup(GString::Empty, GString::Empty, *this, src.parentWin, null, false, 0, true, false) {}

      /** Disable the assignment operator. */
      GMenu& operator= ( const GMenu& ) { return *this; }

   public:

      GMenuPopupItem* getCommand ( int id );

      /**
       * Get the numerical ID that is used internally by the underlying OS
       * to identify the specified high level command ID string.
       */
      int getCommandMapID ( const char* commandID );

      GString getFontNameSize () const;

      /**
       * Return true if and only if this menu window is represented
       * on screen as a menubar window.
       */
      virtual bool isMenubar () const;

      /**
       * Set the enable/disable state of all items that have an
       * ID that equals the specified command ID.
       */
      void setCommandEnableState ( const char* cmdID, bool state );

      /**
       * Set the toggle state of all items that have an
       * ID that equals the specified command ID.
       */
      void setCommandToggleState ( const char* cmdID, bool state );

      void setFontNameSize ( const GString& fontNameSize );

      /**
       * Set whether to use fancy items or not for this menu window
       * and all its sub-menues (if any).
       *
       * @param fancy     True if we shall use fancy items, or else false to
       *                  use the default as of which is defined by the
       *                  underlying system.
       */
      virtual void setUseFancyMenues ( bool fancy );

      void showPopupMenu ( int xpos, int ypos );

      GString userChooseFont ( const GString& titleText, 
                               bool setFont, 
                               GWindow* parentWin = null, 
                               const GString& initialFont = GString::Empty );
};

#endif
