/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_LINEPLOTTER
#define __GLIB_LINEPLOTTER

#include "glib/primitives/aptr.h"
#include "glib/util/GArray.h"
#include "glib/gui/GWindow.h"

/**
 * This is the low level window class that is used to paint
 * dynamic line plotter diagram in a container window.
 *
 * @author  Leif Erik Larsen
 * @since   2000.10.09
 */
class GLinePlotter : public GWindow
{
   private:

      /** Class used to represent sampled points in the line plotter graph. */
      class Pt : public GObject
      {
         public:

            /** The point sample value. */
            double val;

            /** The relative value, to be used as y-pos when plotting. */
            int ypos;

         public:

            Pt ();
            virtual ~Pt ();

         public:

            void recalcYPos ( int graphY, int graphH, double peak );
      };

      // Next are the variables used to maintain the graph it self.
      int w;
      int h;
      int graphX;
      int graphW;
      double cur;
      double peak;
      int columnInc;
      aptr< GArray<Pt> > pts;
      int ptNum;
      GRectangle graphOutlineRect;
      GColor graphColor;
      GColor mfColor;

   public:

      /**
       * @author  Leif Erik Larsen
       * @since   2000.10.12
       * @param   samplerSpeed  See {@link #setSampleSpeed}.
       */
      GLinePlotter ( const GString& name,
                     const GString& constraints,
                     GWindow& parentWin,
                     long winStyle = WS_VISIBLE,
                     long winStyle2 = 0 );

      virtual ~GLinePlotter ();

   private:

      /** Disable the copy constructor. */
      GLinePlotter ( const GLinePlotter& src ) {}

      /** Disable the assignment operator. */
      GLinePlotter& operator= ( const GLinePlotter& ) { return *this; }

   private:

      /** To be called from {@link #addSample} only. */
      aptr< GArray<Pt> > makePts ( const int num );

   protected:

      virtual bool onPaint ( GGraphics& g, const GRectangle& rect );

   public:

      /**
       * Add the specified sample to the line plotter graph.
       *
       * The line plotter graph will be automatically repainted and scrolled
       * if needed.
       *
       * @author  Leif Erik Larsen
       * @since   2000.10.12
       */
      void addSample ( double sample );

      /**
       * Remove all samples from the line plotter, and clears the peak value.
       * Also repaints if needed.
       *
       * @author  Leif Erik Larsen
       * @since   2004.08.11
       */
      void clearAllSamples ();
};

#endif

