/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "glib/gui/GComponentPos.h"
#include "glib/primitives/GString.h"

GComponentPos::GComponentPos ()
              :x(0),
               y(0)
{
}

GComponentPos::GComponentPos ( double x, double y )
              :x(x),
               y(y)
{
}

GComponentPos::GComponentPos ( const GComponentPos& src )
              :GObject(src),
               x(src.x),
               y(src.y)
{
}

GComponentPos::~GComponentPos ()
{
}

GComponentPos& GComponentPos::operator= ( const GComponentPos& src )
{
   GObject::operator=(src);
   this->x = src.x;
   this->y = src.y;
   return *this;
}

GString GComponentPos::toString () const
{
   GString str(16);
   str += '[';
   str += x;
   str += ',';
   str += y;
   str += ']';
   return str;
}

void GComponentPos::setPos ( double x, double y )
{
   this->x = x;
   this->y = y;
}


