/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_BITMAP
#define __GLIB_BITMAP

#include "glib/primitives/GDimension.h"

/**
 * @author  Leif Erik Larsen
 * @since   2001.03.07
 */
class GBitmap
{
   private:

      HBITMAP hbm;
      bool autoDestroyTheBitmap;
      GDimension size;

   public:

      /**
       * Create an empty bitmap object (ready for painting) that is device 
       * compatible with the specified graphics object.
       *
       * Use {@link GGraphics#GGraphics(GBitmap&, GWindow&, GGraphics::Handle)}
       * to create a graphics object that can be used to draw into the 
       * bitmap object. The bitmap can then be painted on another 
       * graphics object with {@link GGraphics#drawBitmap}.
       *
       * @author  Leif Erik Larsen
       * @since   2004.03.07
       */
      GBitmap ( class GGraphics& g, 
                int width, 
                int height, 
                int colorbits = 0 );

      /**
       * Create a bitmap object that wraps the specified platform 
       * dependent bitmap handle.
       *
       * @author  Leif Erik Larsen
       * @since   2001.03.07
       */
      GBitmap ( HBITMAP hbm, bool autoDestroy );

      virtual ~GBitmap ();

   private:

      /** Disable the copy constructor. */
      GBitmap ( const GBitmap& ) {}

      /** Disable the assignment operator. */
      GBitmap& operator= ( const GBitmap& ) { return *this; }

   public:

      HBITMAP getHBM () const;
      const GDimension& getSize () const;
};

#endif

