/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "glib/gui/GBitmap.h"
#include "glib/gui/GGraphics.h"

GBitmap::GBitmap ( GGraphics& g,
                   int width,
                   int height,
                   int colorbits )
        :hbm(null),
         autoDestroyTheBitmap(true),
         size(width, height)
{
   HAB hab = GProgram::hAB;
   HDC hdcComp = ::GpiQueryDevice(g.getHandle());
   HDC hdcMem = ::DevOpenDC(hab, OD_MEMORY, "*", 0, null, hdcComp);
   SIZEL sizel = { 0, 0 };
   HPS hpsMem = ::GpiCreatePS(hab, hdcMem, &sizel, PU_PELS | GPIF_DEFAULT | GPIT_MICRO | GPIA_ASSOC);
   ::GpiCreateLogColorTable(hpsMem, 0, LCOLF_RGB, 0, 0, null);
   LONG bmFormats[2];
   ::GpiQueryDeviceBitmapFormats(hpsMem, 2L, bmFormats);
   BITMAPINFOHEADER2 bmInfo;
   memset(&bmInfo, 0, sizeof(bmInfo));
   bmInfo.cbFix = sizeof(bmInfo);
   bmInfo.cx = width;
   bmInfo.cy = height;
   bmInfo.ulColorEncoding = BCE_RGB;
   bmInfo.cPlanes = SHORT(bmFormats[0]);
   bmInfo.cBitCount = SHORT(colorbits > 0 ? colorbits : bmFormats[1]);
   hbm = ::GpiCreateBitmap(hpsMem, &bmInfo, 0L, null, null);
   ::GpiDestroyPS(hpsMem);
   ::DevCloseDC(hdcMem);
}

GBitmap::GBitmap ( HBITMAP hbm, bool autoDestroy )
        :hbm(hbm),
         autoDestroyTheBitmap(autoDestroy)
{
   BITMAPINFOHEADER header;
   header.cbFix= sizeof(header);
   ::GpiQueryBitmapParameters(hbm, &header);
   size.set(header.cx, header.cy);
}

GBitmap::~GBitmap ()
{
   if (autoDestroyTheBitmap && hbm)
   {
      ::GpiDeleteBitmap(hbm);
   }
}

HBITMAP GBitmap::getHBM () const { return hbm; }
const GDimension& GBitmap::getSize () const
{
   return size;
}
