/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_ABSTRACTTEXTFIELD
#define __GLIB_ABSTRACTTEXTFIELD

#include "glib/gui/GWindow.h"

/**
 * @since  2000.01.29
 * @author Leif Erik Larsen
 */
class GAbstractTextField : public GWindow
{
   protected:

      GColor bckColorEnabled;
      GColor bckColorDisabled;
      GColor frgColorEnabled;
      GColor frgColorDisabled;

   protected:

      /**
       * @author  Leif Erik Larsen
       * @since   2004.08.27
       */
      GAbstractTextField ( GWindow& parentWin,
                           const GString& name = GString::Empty,
                           const GString& constraints = GString::Empty,
                           long winStyle = WS_VISIBLE,
                           long winStyle2 = WS2_OS2Y );
      
   public:

      virtual ~GAbstractTextField ();

   private:

      /** Disable the copy constructor. */
      GAbstractTextField ( const GAbstractTextField& src ) {}

      /** Disable the assignment operator. */
      GAbstractTextField& operator= ( const GAbstractTextField& ) { return *this; }

   protected:

      virtual bool onBackgroundColorChanged ( const GColor& color );
      virtual bool onFontNameSizeChanged ( const GString& fontNameSize );
      virtual bool onForegroundColorChanged ( const GColor& color );

   public:

      virtual void changeValue ( const GString& newValue, bool notify = true );
      virtual GString queryValue () const;
      virtual bool isEmpty () const;

      virtual void appendText ( const GString& text ) = 0;
      virtual void copy () const = 0;
      virtual void cut () = 0;
      virtual int getSelectionEnd () const = 0;
      virtual int getSelectionStart () const = 0;
      virtual int getTextLength () const = 0;
      virtual void paste () = 0;
      virtual GWindow& getPeer () const = 0;

      /**
       * Limit the length of the text that can be inserted by user or program
       * to the editor buffer.
       */
      virtual void setMaxTextLength ( int maxLength ) = 0;

      virtual void setSelection ( int selStart, int selEnd ) = 0;

      /**
       * Replace the current text (if any) in the Text Entry with the
       * specified text.
       */
      virtual void setText ( const GString& text ) = 0;

      virtual void grabFocus ( bool force = false );

      bool getInsertMode () const;
      GString getText () const;
      bool isAnySelectedText () const;

      /**
       * Move the cursor to the end of the current line.
       */
      void moveCursorEnd ();

      /**
       * Move the cursor in the start of the current line.
       */
      void moveCursorHome ();

      /**
       * Move the cursor one step to the left.
       */
      void moveCursorLeft ();

      /**
       * Move the cursor one step to the right.
       */
      void moveCursorRight ();

      void moveCursorWordLeft ();

      void moveCursorWordRight ();

      /**
       * Overrides <i>GWindow::queryProfile()</i> in order to activate
       * the color properties of the MLE with respect to its
       * enabled or disabled state.
       */
      virtual void queryProfile ( const GString& sectName );

      void selectAll ();

      /**
       * We will change the background color of the MLE so that it is
       * gray (by default) when it is disabled.
       */
      virtual void setEnabled ( bool flag = true, bool repaint = true );

      virtual void setOily ( bool flag );

      void setInsertMode ( bool flag );

      /**
       * Overrides <i>GWindow::writeProfile()</i> in order to write the
       * color properties of the MLE with respect to its
       * enabled or disabled state.
       */
      virtual void writeProfile ( const GString& sectName, bool force = false );
};

#endif
