/* --------------------------------------------------------------------------
 *
 * This file was part of the "More for C++" library.
 * Copyright (c) 1999-2003 by Thorsten Goertz.
 * The "More for C++" library is free software; you can
 * redistribute it and/or modify it under the terms of the license
 * that comes with http://www.morefor.org/.
 *
 * ------------------------------------------------------------------------ */

#ifndef ALIGNINGHEAPMANAGER_HPP
#define ALIGNINGHEAPMANAGER_HPP

////////////////////////////////////////////////////////////////////////////////

#include "glib/gc/heapmanager.h"

////////////////////////////////////////////////////////////////////////////////

class AligningHeapManager: public HeapManager
{
public:
   AligningHeapManager( );
   virtual ~AligningHeapManager( );
   virtual void* createObject( size_t nSizeOfObject );
   virtual void destroyObject( void* pObject );
   virtual void compactHeap( );

private:
   class AlignedObjects
   {
      public:
      AlignedObjects( size_t nAlignment );
      virtual ~AlignedObjects( );
      void* createObject( size_t nSizeOfObject );
      size_t compact( );

      private:
      size_t m_nAlignment;
      size_t m_nCapacity;
      size_t m_nNextObject;
      void* m_pObjects;
      AlignedObjects* m_pNextAlignedObjects;
   };

   AlignedObjects m_alignedObjects0;
   AlignedObjects m_alignedObjects1;
   AlignedObjects m_alignedObjects2;
   AlignedObjects m_alignedObjects3;
   AlignedObjects m_alignedObjects4;
   AlignedObjects m_alignedObjects5;
};

////////////////////////////////////////////////////////////////////////////////

#endif
