/* OS/2 compatibility defines.
   This file is intended to be included from config.h
   Copyright (C) 2001-2002 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU Library General Public License as published
   by the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
   USA.  */

/* When included from os2compat.h we need all the original definitions */

#include<sys/types.h>
#include<sys/param.h>


/* This function tries to determine the current charset using DosQueryCp().
   In the following cases NULL is returned:
   1) The system is not running in OS/2 mode (but DOS, whatever).
   2) We are not connected to the /dev/con terminal, i.e. the codepage
      information may be useless (e.g. for an xterm) and is ignored.
   3) DosQueryCp() fails. */
extern const char* 
_nlos2_get_charset (void);


/* This function compares a given codeset name with an alias.
   codeset and aliases are assumed to be identical if codeset is
   identical to the first part of aliases, e.g. "en_US" and
   "en_US.ISO-8859-1" are identical. */
extern int
_nlos2_cmp_codeset (const char *codeset, const char *aliases);


/* path is assumed to be a list of directories separated by PATH_SEPARATOR.
   Every directory is processed. unixrootify() is used to find out whether
   these directories begin with '/' or '\\'. If this is the case (i.e.
   if there is no drive letter) the UNIXROOT drive letter is prepended
   to that directory. If path is a valid path this function returns a valid
   path, too.
   Example ($UNIXROOT is set to "e:"):
   ".;/usr/local;d:/usr/local;/etc;e:/etc"
   -> ".;e:/usr/local;d:/usr/local;e:/etc;e:/etc" */
extern char*
_nlos2_unixrootify_path (const char *path);


/* This function delivers GNULOCALEDIR if available, otherwise the
   unixrootified version of path. */
extern const char*
_nlos2_deliver_path (const char *path);


/* This function delivers the first directory of GNULOCALEDIR if available,
   otherwise the unixrootified version of dirname (i.e. UNIXROOT is
   prepended to dirname). */
extern const char* 
_nlos2_deliver_dir (const char *dirname);


#undef HAVE_STRCASECMP
#define HAVE_STRCASECMP 1
#define strcasecmp stricmp
#define strncasecmp strnicmp

/* We have our own getenv() which works even if library is compiled as DLL */
//#define getenv _nl_getenv

/* Older versions of gettext used -1 as the value of LC_MESSAGES */
#define LC_MESSAGES_COMPAT (-1)

