uses door,crt;

Function MenuLightbar: Integer;
const
  TotalEntrys = 5;                               { Put # of choices Here    }
  Entrys : array[1..TotalEntrys] of String[80] =
    (' Choice #1 ',                              { Put the choices Here     }
     ' Choice #2 ',
     ' Choice #3 ',
     ' Choice #4 ',
     ' Quit      ');
  BarFG = 9;                                     { Foreground Color of LBar }
  BarBG = 1;                                     { Background Color of LBar }
  TxtFG = 7;                                     { FG Color of regular text }
  TxtBG = 0;                                     { BG Color of regular text }

var
  WhereAt, I: Integer;
  Ch: Char;
  X, Y: Byte;

procedure up;
Begin {UP}
  Dgotoxy(X, Y+WhereAt-1);
  Dcolor(TxtFG, TxtBG);
  Dwrite(Entrys[WhereAt]);
  If WhereAt > 1 Then Dec(WhereAt);
  Dgotoxy(X, Y+WhereAt-1);
  Dcolor(BarFG, BarBG);
  DWrite(Entrys[WhereAt]);
end;

procedure down;
Begin {DOWN}
  Dgotoxy(X, Y+WhereAt-1);
  Dcolor(TxtFG, TxtBG);
  Dwrite(Entrys[WhereAt]);
  If WhereAt < TotalEntrys Then Inc(WhereAt);
  Dgotoxy(X, Y+WhereAt-1);
  Dcolor(BarFG, BarBG);
  DWrite(Entrys[WhereAt]);
end;

begin
  X:=WhereX;
  Y:=WhereY;
  WhereAt:=1;
  Dgotoxy(X, Y);
  Dcolor(BarFG, BarBG);
  DWrite(Entrys[1]);
  For I:=2 to TotalEntrys do
    begin
      Dgotoxy(X, Y+I-1);
      Dcolor(TxtFG, TxtBG);
      DWrite(Entrys[I]);
    end;
  Dgotoxy(X+Length(Entrys[I]), Y);
  repeat
    dreadc(ch);
    if (ch = '[') or (ch = #00) then { Ansi up/down or Arrow up/down prefix }
      begin
        dreadc(ch);
        case upcase(ch) of
          #72,'A': up;
          #80,'B': down;
          #75: inctime(5);
          #77: dectime(5);
        end;
      end;
  until ch = #13;                {Until Enter is pressed               }
  MenuLightbar:=WhereAt;
  Dcolor(TxtFG, TxtBG);
end;

var
  Choice: Integer;

begin
  doorname:='Lightbar Door';     {Set the door name                    }
  cfgfn:='Lbar.cfg';             {Config File name = lbar.cfg          }
  loadcfg;                       {Load/Parse the config file/drop file }
  dclrscr;                       {Clear screen                         }
  dgotoxy(5,5);                  {Lightbars start at 5,5               }
  Choice:=Menulightbar;          {Execute the lightbar funct, return   }
                                 {The choice number in integer 'Choice'}
  Dgotoxy(5,11);
  case Choice of
    1 : dpipeln('|12ya chose: choice #1');
    2 : dpipeln('|12ya chose: choice #2');
    3 : dpipeln('|12ya chose: choice #3');
    4 : dpipeln('|12ya chose: choice #4');
    5 : dpipeln('|12ya chose: quit');
  end;
end.                             {end!                                 }
