/*
	PLANETS: TEOS Structures

	Converted from PASCAL by Mike Dillon aka GSValore.

	These structures included are only the DAT files structures.
	The structures have been modified to be more optimized than
	their original pascal counterparts.  They have the same
	usage and size so compatibility issues are not a concern.
	For security reasons the GAME.DAT file is not available for
	modifications.  Planets: TEOS was originally written by
	Seth Able, founder of Robinson Technologies.

	-- THESE STRUCTURES ARE PUBLIC DOMAIN --
	** Use at your own risk!!

        Revision:
                05-20-2000 Modified the source to be completely ANSI C
                           compliant.

        Tested with:
                     Visual C++ 4.0 Standard
                     DJGPP 2.952

        When you compile, confirm these structure sizes:
        teos_ship       :  146
        teos_enemy      : 1309
        teos_player     :  689
        teos_planet     : 2269
        teos_cartel     :  212

        Planets: The Exploration Of Space Copyright (C) Metropolis Gameport
        Borland C++ Copyright (C) Inprise Corporation
        Visual C++ Copyright (C) Microsoft Corporation
        DJGPP Copyright (C) D.J. Delorie
*/

#if !defined( P_TEOS_STRUCTURES__H )
#define P_TEOS_STRUCTURES__H 1

/* Structure alignment must be 1.  If your compiler supports this pragma */
/* please include your compiler in the IF statement.                     */
#if defined( _WIN32 ) || defined( DJGPP )
        #pragma pack( 1 )
#endif

/* Structure for each ship's data.  Found in SHIP.DAT */
typedef struct {
        signed short int        ship_odds;        /* Ship's Odds?                   */
        signed char             k[ 9 ];           /* Unknown (BOOLEAN) Array        */
        signed short int        owner;            /* Owner's #?                     */
        signed short int        j[ 8 ];           /* Unknown Array Values           */
        signed char             ship_model[ 31 ]; /* Ship's Model type              */
        signed char             ship_look[ 9 ];   /* Ship's Design?                 */
        signed long int         akills;           /* Alliance Kills                 */
        signed long int         mkills;           /* Maraken Kills                  */
        signed long int         nkills;           /* Neutral Kills                  */
        signed long int         price;            /* Ship's value                   */
        signed char             ansi_name[ 9 ];   /* ANSI name for the ship         */
        signed long int         max_reactor;      /* Maximum reactor charge         */
        signed long int         max_fighters;     /* Maximum number of fighters the */
                                                  /* ship can carry                 */
        signed long int         max_holds;        /* Maximum number of holds the    */
                                                  /* ship can have                  */
        signed long int         max_shields;      /* Maximum shield amount          */
        signed long int         max_torp;         /* Maximum torpedo amount         */
        signed long int         fighters;         /* Amount of fighters ship        */
                                                  /* currently has                  */
        signed long int         shields;          /* Amount of shields ship         */
                                                  /* currently has                  */
        signed long int         jumps_per_day;    /* Amount of warp jumps           */
                                                  /* this ship can currently do     */
        signed long int         l[ 4 ];           /* Unknown Array Values           */
        signed long int         holds;            /* Amount of holds the ship       */
                                                  /* currently has                  */
} teos_ship;


/* Structure of the ENEMIES.DAT file. */
typedef struct
{
        signed char             name[31];       /* Enemy's Name                                   */
        signed char             ship[31];       /* Enemy's Ship name                              */
        signed char             boast[161];     /* 2-80 char strings of this                      */
                                                /* enemy's boast phrase                           */
        signed char             string[161];    /* Same as above [Friend of?]                     */
        signed short int        cargo[40];      /* Array of the cargo information                 */
        signed char             mad[161];       /* Mad Phrase (format of boast)                   */
        signed char             run[161];       /* Running Phrase (format of boast)               */
        signed char             win[161];       /* "I won" phrase (format of boast)               */
        signed long int         exp;            /* Enemy's Experience                             */
        signed long int         fighters;       /* Amount of fighters on the ship                 */
        signed long int         torp;           /* Amount of torpedoes on the ship                */
        signed long int         gold;           /* Amount of gold the enemy gives?                */
        signed char             org;            /* Enemy's Alliance? [Alliance, Maraken, Neutral] */
        signed long int         shields;        /* Amount of shields the enemy has                */
        signed char             like[200];      /* Unknown (Char array not string)                */
        signed long int         holds;          /* Amount of ship holds                           */
        signed long int         power;          /* Amount of ship's power                         */
        signed long int         att;            /* Unknown                                        */
        signed long int         brain;          /* Unknown                                        */
        signed long int         planet;         /* Unknown (Enemy owns a planet?)                 */
        signed long int         l[4];           /* Unknown Array Values                           */
        signed char             male;           /* Enemy male? (BOOLEAN)                          */
        signed char             blown_up;       /* Enemy defeated? (BOOLEAN)                      */
        signed char             k[7];           /* Unknown Array (BOOLEAN) Values                 */
        signed short int        gift;           /* Unknown                                        */
        signed short int        j[8];           /* Unknown Array Values                           */
        signed short int        ship_odds;      /* Odds of enemy winning?                         */
        signed char             ship_model[31]; /* Model of enemy's ship                          */
        signed char             ship_look[9];   /* Ship's design?                                 */
        signed long int         akills;         /* Alliance Kills                                 */
        signed long int         mkills;         /* Maraken Kills                                  */
        signed long int         nkills;         /* Neutral Kills                                  */
        signed long int         max_reactor;    /* Maximum Reactor charge of ship                 */
        signed long int         max_fighters;   /* Maximum amount of fighters                     */
                                                /* the ship can carry                             */
        signed long int         max_holds;      /* Maximum amount of holds                        */
                                                /* the ship can have                              */
        signed long int         max_shields;    /* Maximum amount of shields                      */
                                                /* the ship can have                              */
        signed long int         max_torp;       /* Maximum amount of torpedoes                    */
                                                /* the ship can have                              */
        signed long int         jumps_per_day;  /* Amount of jumps the ship                       */
                                                /* can do in one day                              */
} teos_enemy;                                                                                                


/* Structure of the TRADER.DAT file.  Each player is contained in this */
/* file.  Max of 200 players, anything beyond the 200 will be lost or  */
/* just simply unused.                                                 */
typedef struct {
        signed char             name[ 26 ];        /* Player's Handle                      */
        signed char             real_name[ 26 ];   /* Player's Real Name (from BBS)        */
        signed char             ship_name[ 26 ];   /* Ship's Name                          */
        signed char             sci_officer[ 26 ]; /* Science Officer of the ship          */
        signed char             wep_officer[ 26 ]; /* Weapons Officer of the ship          */
        signed char             flight[ 256 ];     /* Flight path: (2 chars for each stop) */
        signed long int         bad;               /* Unknown                              */
        signed long int         shields;           /* Number of shields ship has           */
        signed long int         planet;            /* Planet Currently at                  */
        signed long int         fighters;          /* Number of fighters on ship           */
        signed long int         holds;             /* Number of holds on ship              */
        signed long int         power;             /* Amount of Reactor power              */
        signed long int         path;              /* Unknown                              */
        signed long int         quest;             /* Unknown                              */
        signed char             rate;              /* Unknown (Alignment Rating?)          */
        signed char             expert;            /* Unknown                              */
        signed char             why;               /* Unknown                              */
        signed char             tip;               /* Unknown                              */
        signed char             cloaked;           /* Is ship cloaked? (BOOLEAN)           */
        signed char             male;              /* Is player male? (BOOLEAN)            */
        signed long int         gold;              /* Amount of money player               */
                                                   /* has in hand.                         */
        signed long int         bank;              /* Amount of money player               */
                                                   /* has in the bank.                     */
        signed long int         exp;               /* Player's experience                  */
        signed short int        last_day_on;       /* Last day player was on               */
        signed long int         o[ 6 ];            /* Unknown Array Values                 */
        signed short int        ship_odds;         /* Ship's odds [5 to 100]               */
        signed char             ship_model[ 31 ];  /* Ship's Model                         */
        signed long int         max_fighters;      /* Maximum fighters ship                */
                                                   /* can carry                            */
        signed long int         max_holds;         /* Maximum holds ship can               */
                                                   /* have                                 */
        signed short int        cargo[ 40 ];       /* Cargo being carried                  */
        signed char             on_now;            /* Is player on? (BOOLEAN)              */
        signed char             hour_on;           /* Last hour on                         */
        signed char             minute_on;         /* Last Minute on                       */
        signed long int         cloak_level;       /* Level the ship is cloaked at (0-9)   */
        signed long int         l[ 5 ];            /* Unknown Array Values                 */
        signed short int        cartel;            /* Cartel the player belongs to         */
        signed short int        j[ 8 ];            /* Unknown Array Values                 */
        signed long int         jumps_per_day;     /* Max jumps the ship can do            */
                                                   /* per day                              */
        signed long int         max_shields;       /* Maximum shields the ship             */
                                                   /* can have                             */
        signed char             ship_look[ 9 ];    /* Ship ANSI symbol                     */
        signed long int         akills;            /* Alliance Kills                       */
        signed long int         mkills;            /* Maraken Kills                        */
        signed long int         nkills;            /* Neutral Kills                        */
        signed long int         max_reactor;       /* Maximum Reactor Charge               */
        signed long int         max_torp;          /* Maximum Torpedo count                */
        signed char             org;               /* Alliance [Alliance, Maraken Neutral] */
        signed char             l1;                /* Unknown                              */
        signed char             kicked_out;        /* If non-zero the user cannot          */
                                                   /* play until that number of            */
                                                   /* days is up.                          */
        signed char             torp;              /* Torpedo count?                       */
        signed char             d5;                /* Unknown                              */
        signed char             d6;                /* Unknown                              */
        signed char             dead;              /* Is Player Dead? (BOOLEAN)            */
        signed char             busy;              /* Is Player Busy? (BOOLEAN)            */
        signed char             deleted;           /* Is Player Deleted? (BOOLEAN)         */
        signed char             nice;              /* Is Player Nice? (BOOLEAN)            */
        signed char             blacklisted;       /* Set to prevent player                */
                                                   /* from buying weapons at the           */
                                                   /* planet they are attacking            */
                                                   /* (BOOLEAN)                            */
        signed char             e6;                /* Unknown (BOOLEAN)                    */
        signed short int        t[ 6 ];            /* RESERVED                             */
} teos_player;


/* Structure for PLANETS.DAT.  You can append to this file just as long     */
/* as you don't go beyond the max of 99.  You can also delete a planet but  */
/* make sure you check all the players to see if any are on that planet, if */
/* they are then set their more[4] value to TRUE                            */
typedef struct {                                                               
        signed char             name[ 51 ];        /* Planet's Name                */
        signed char             desc[ 5 ][ 131 ];  /* Description of the planet    */
        signed char             vname[ 41 ];       /* Village Name?                */
        signed char             tlook[ 121 ];      /* Trader's looks               */
        signed char             tname[ 41 ];       /* Trader's name                */
        signed char             tdesc[ 2 ][ 101 ]; /* Trader's description         */
        signed short int        rate[ 40 ];        /* Rating of the items?         */
        signed char             shop[ 20 ];        /* Array of (BOOLEAN)           */
                                                   /* Index #:                     */
                                                   /* 0 = Bank                     */
                                                   /* 1 = Alliance                 */
                                                   /* 2 = Maraken                  */
                                                   /* 3 = Dreamor Temple           */
                                                   /* 4 = Graffiti Wall            */
        signed short int        setting[ 20 ];     /* Settings?                    */
                                                   /* Index #:                     */
                                                   /* 0 = amount of fuel           */
                                                   /* 1 = percentage               */
        signed char             sname[ 20 ][ 31 ]; /* Shop names                   */
                                                   /* Values of the shop           */
                                                   /* Boolean                      */
        signed char             more[ 40 ];        /* Array of (BOOLEAN)           */
                                                   /* Index #:                     */
                                                   /* 1 = Trader Male?             */
                                                   /* 2 = Can you Eden Warp here?  */
                                                   /* 3 = Utopia Defense?          */
        signed short int        owner;             /* Owner's Number (Player)      */
        signed long int         pop;               /* Planet's Population          */
        signed long int         power;             /* Planet's Fighter count       */
        signed long int         graph;             /* Unknown                      */
        signed long int         gold;              /* Planet's Wealth?             */
        signed long int         income;            /* Planet's Income              */
        signed long int         ntrades;           /* Number of trades currently   */
        signed char             mode;              /* Unknown                      */
        signed char             nuke;              /* Unknown                      */
        signed char             c3;                /* Unknown                      */
        signed char             c4;                /* Unknown                      */
        signed char             cplace[ 4 ][ 61 ]; /* Custom Place (Not Used)      */
        signed char             cpname[ 4 ][ 21 ]; /* Custom Place Name (Not Used) */
} teos_planet;

/* Structure of the CARTEL.DAT file. */
typedef struct {
        signed char             deleted;           /* Cartel Deleted? (BOOLEAN) */
        signed char             name[ 26 ];        /* Cartel's Name             */
        signed char             password[ 11 ];    /* Cartel's Password         */
        signed short int        ceo;               /* CEO's Player number       */
        signed short int        member[ 10 ];      /* Numbers of the members    */
                                                   /* Each entry reprensents a  */
                                                   /* Player's actual number    */
        signed short int        hate_list[ 20 ];   /* List of players that      */
                                                   /* the cartel hates          */
        signed short int        friend_list[ 20 ]; /* List of players the       */
                                                   /* cartel is friends with    */
        signed long int         a[ 9 ];            /* Unknown Array Values      */
        signed long int         b[ 9 ];            /* Unknown Array Values      */
} teos_cartel;

#endif
