/*
     Copyright (c) 2000,2010 Michael Dillon

     Permission is hereby granted, free of charge, to any person obtaining a copy
     of this software and associated documentation files (the "Software"), to deal
     in the Software without restriction, including without limitation the rights
     to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
     copies of the Software, and to permit persons to whom the Software is
     furnished to do so, subject to the following conditions:
     
     The above copyright notice and this permission notice shall be included in
     all copies or substantial portions of the Software.
     
     THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
     IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
     FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
     AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
     LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
     OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
     THE SOFTWARE.
*/
#include <iostream>
#include <fstream>
#include <iomanip>
#include <cstdlib>
#include <cstdio>
#include <cerrno>
#include <cctype>
#include <ctime>
#include <cstring>

using namespace std;

#include "cstats.h"
#include "utilfunc.h"

/**************************************************************************
 * PLANETS: THE EXPLORATION OF SPACE
 *
 * Specific Functions for Planets: TEOS
 **************************************************************************/
//int teosDelChk( const void *player )
int teosDelChk( teos_player *player )
{
//        return ( ( ( teos_player * )player )->deleted );
        return ( player->deleted );
}

//void teosAssign( SORT *psort, const void *object )
void teosAssign( SORT *psort, teos_player *object )
{
//        psort->Experience = ( ( teos_player * )object )->exp;
        psort->Experience = object->exp;
}

//void teosOutput( PRGSCAN *prgScan, const void *object )
void teosOutput( PRGSCAN *prgScan, teos_player *p )
{
        const char      szStatFile[] = "pstat.htm";
        const char      szCartel[] = "cartel.dat";
        char            cartelPath[ CSTATS_MAX_PATH ] = "\x0";
        ofstream        statFile;
        ifstream        cartelFile;
        teos_cartel     cartel;
//        teos_player     *p = ( teos_player * )object;

        statFile.open( szStatFile, ios::app );
        if ( !statFile )
        {
                cerr << "Unable to open " << szStatFile << " for append/output." << endl;
                return;
        }

        statFile << "<tr bgcolor=\"#000000\">" << endl;
        /* Female? */
        statFile << "<td width=\"3%\" align=\"center\">" << endl;
        if ( p->male == 0 )
        {
                htmlSetColor( &statFile, 0xff00ffL );
                statFile << "F" << "</font>" << endl;
        }
        statFile << "</td>" << endl;
        /* Alignment */
        statFile << "<td width=\"3%\" align=\"center\">" << endl;
        if ( p->org > 0 )
        {
                htmlSetColor( &statFile, 0x00ffffL );
                statFile << "A" << "</font>" << endl;
        }
        else if ( p->org < 0 )
        {
                htmlSetColor( &statFile, 0xff0000L );
                statFile << "M" << "</font>" << endl;
        }
        statFile << "</td>" << endl;
        /* Name */
        statFile << "<td width=\"25%\" align=\"left\">" << endl;
        statFile << sansirem( strptoc( ( char * )p->name ) ) << "</td>" << endl;
        /* Experience */
        statFile << "<td width=\"17%\" align=\"right\">" << endl;
        htmlSetColor( &statFile, 0x00f0f0L );
        statFile << ultoac( (unsigned)p->exp ) << "</font></td>" << endl;
        /* Cartel */
        statFile << "<td width=\"17%\" align=\"center\">" << endl;
        if ( p->cartel )
        {
                strcpy( cartelPath, prgScan->PrgPath );
                strcat( cartelPath, szCartel );
                cartelFile.open( cartelPath, ios::binary | ios::in );
                if ( !cartelFile )
                {
                        statFile << "???" << endl;
                }
                else
                {
//                        if ( !LoadBinFileRec( ( void * )&cartel, sizeof( teos_cartel ), ( p->cartel - 1 ), &cartelFile ) )
                        if ( !LoadBinFileRec<teos_cartel>( &cartel, ( p->cartel - 1 ), &cartelFile ) )
                                statFile << sansirem( strptoc( ( char * )cartel.name ) ) << endl;
                        else
                                statFile << "???" << endl;
                        cartelFile.close();
                }
        }
        statFile << "</td>" << endl;
        /* Status */
        statFile << "<td width=\"10%\" align=\"center\">" << endl;
        if ( p->dead )
        {
                htmlSetColor( &statFile, 0xff0000L );
                statFile << "Dead" << "</font>" << endl;
        }
        else
                statFile << "Alive" << endl;
        statFile << "</td>" << endl;
        /* Ship Name and Model */
        statFile << "<td width=\"25%\" align=\"left\">" << endl;
        htmlSetColor( &statFile, 0x00c000L );
        statFile << strptoc( ( char * )p->ship_name );
        statFile << "</font>";
        statFile << "[";
        htmlSetColor( &statFile, 0x00c8ffL );
        statFile << sansirem( strptoc( ( char * )p->ship_model ) ) << "</font>";
        statFile << "]";
        statFile << "</td>" << endl;

        statFile.flush();
        statFile.close();
}

int teosCompare( const void *p1, const void *p2 )
{
        SORT *teos_p1 = ( SORT * )p1, *teos_p2 = ( SORT * )p2;
        if ( teos_p1->Experience == teos_p2->Experience )
                return ( 0 );
        if ( teos_p1->Experience < teos_p2->Experience )
                return ( 1 );
        else
                return ( -1 );
}

void teosHTML( int task )
{
        const char      szStatFile[] = "pstat.htm";
        const char      szTitle[] = "Planets: The Exploration Of Space Player Statistics";
        ofstream        statFile;
        if ( task == 0 )
        {
                statFile.open( szStatFile );
                if ( !statFile )
                {
                        cerr << "Unable to open " << szStatFile << " for output." << endl;
                        return;
                }
                cout << "Writing the statistics to \"" << szStatFile << "\"..." << endl;
                htmlStatHeader( &statFile, szTitle );
                statFile << "<tr bgcolor=\"#000080\">" << endl;
                statFile << "<td width=\"3%\" align=\"center\">&nbsp;</td>" << endl;        /* Female?           */
                statFile << "<td width=\"3%\" align=\"center\">&nbsp;</td>" << endl;        /* Alignment         */
                statFile << "<td width=\"25%\" align=\"left\">Trader\'s Name</td>" << endl; /* Player's Name     */
                statFile << "<td width=\"17%\" align=\"right\">Experience</td>" << endl;    /* Experience        */
                statFile << "<td width=\"17%\" align=\"center\">Cartel</td>" << endl;       /* Cartel            */
                statFile << "<td width=\"10%\" align=\"center\">Status</td>" << endl;       /* Alive?            */
                statFile << "<td width=\"25%\" align=\"left\">Ship[Model]</td>" << endl;    /* Ship name & model */
                statFile << "</tr>" << endl;
                statFile.flush();
        }
        else
        {
                statFile.open( szStatFile, ios::app );
                if ( !statFile )
                {
                        cerr << "Unable to open " << szStatFile << " for output." << endl;
                        return;
                }
                htmlStatClose( &statFile );
        }

        statFile.close();
}
