/*
     Copyright (c) 2000,2010 Michael Dillon

     Permission is hereby granted, free of charge, to any person obtaining a copy
     of this software and associated documentation files (the "Software"), to deal
     in the Software without restriction, including without limitation the rights
     to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
     copies of the Software, and to permit persons to whom the Software is
     furnished to do so, subject to the following conditions:
     
     The above copyright notice and this permission notice shall be included in
     all copies or substantial portions of the Software.
     
     THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
     IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
     FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
     AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
     LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
     OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
     THE SOFTWARE.
*/
#include <iostream>
#include <fstream>
#include <iomanip>
#include <cstdlib>
#include <cstdio>
#include <cerrno>
#include <cctype>
#include <ctime>
#include <cstring>

using namespace std;

#include "cstats.h"
#include "utilfunc.h"

/***************************************************************************
 * LEGEND OF THE RED DRAGON II
 *
 * Specific functions for L.O.R.D. 2
 ***************************************************************************/
//int l2DelChk( const void *player )
int l2DelChk( l2_player *player )
{
//        return ( ( ( l2_player * )player )->deleted );
        return ( player->deleted );
}

//void l2Assign( SORT *psort, const void *object )
void l2Assign( SORT *psort, l2_player *object )
{
//        psort->Experience = ( ( l2_player * )object )->p[ 0 ];
        psort->Experience = object->p[ 0 ];
}

//void l2Output( PRGSCAN *prgScan, const void *object )
void l2Output( PRGSCAN *prgScan, l2_player *p )
{
        const char      szStatFile[] = "l2stat.htm";
//        l2_player       *p = ( l2_player * )object;
        ofstream        statFile;

        statFile.open( szStatFile, ios::app );
        if ( !statFile )
        {
                cerr << "Unable to open " << szStatFile << " for append/output!" << endl;
                return;
        }
        statFile << "<tr bgcolor=\"#000000\">" << endl;
        /* Female? */
        statFile << "<td width=\"3%\" align=\"center\">" << endl;
        if ( p->sex_male != 1 )
        {
                htmlSetColor( &statFile, 0xff00ffL );
                statFile << "F" << "</font>" << endl;
        }
        statFile << "</td>" << endl;
        /* Alignment */
        statFile << "<td width=\"3%\" align=\"center\">" << endl;
        if ( p->p[ 6 ] < 0 )       /* Evil */
        {
                htmlSetColor( &statFile, 0xff0000L );
                statFile << "E" << "</font>" << endl;
        }
        else if ( p->p[ 6 ] > 0 )  /* Good */
        {
                htmlSetColor( &statFile, 0xffffffL );
                statFile << "G" << "</font>" << endl;
        }
        statFile << "</td>" << endl;
        /* Name */
        statFile << "<td width=\"30%\" align=\"left\">" << endl;
        statFile << sansirem( strptoc( ( char * )p->name ) ) << "</td>" << endl;
        /* Experience */
        statFile << "<td width=\"24%\" align=\"right\">" << endl;
        statFile << ultoac( (unsigned)p->p[ 0 ] ) << "</td>" << endl;
        /* Level */
        statFile << "<td width=\"15%\" align=\"right\">" << endl;
        statFile << ultoac( (unsigned)p->p[ 8 ] ) << "</td>" << endl;
        /* Quests Completed */
        statFile << "<td width=\"15%\" align=\"center\">" << endl;
        statFile << p->p[ 17 ] << "</td>" << endl;
        /* Status */
        statFile << "<td width=\"10%\" align=\"center\">" << endl;
        if ( p->dead == 1 )
        {
                htmlSetColor( &statFile, 0xff0000L );
                statFile << "Dead" << "</font>" << endl;
        }
        else
                statFile << "Alive" << endl;
        statFile << "</td>" << endl;

        statFile << "</tr>" << endl;

        statFile.flush();
        statFile.close();
}

int l2Compare( const void *p1, const void *p2 )
{
        SORT *l2sort1 = ( SORT * )p1, *l2sort2 = ( SORT * )p2;
        if ( l2sort1->Experience == l2sort2->Experience )
                return ( 0 );
        if ( l2sort1->Experience < l2sort2->Experience )
                return ( 1 );
        else
                return ( -1 );
}

void l2HTML( int task )
{
        const char      szStatFile[] = "l2stat.htm";
        const char      szTitle[] = "Legend Of the Red Dragon II Player Statistics";
        ofstream        statFile;
        if ( task == 0 )
        {
                statFile.open( szStatFile );
                if ( !statFile )
                {
                        cerr << "Unable to open " << szStatFile << " for output!" << endl;
                        return;
                }
                cout << "Writing the statistics to \"" << szStatFile << "\"..." << endl;
                htmlStatHeader( &statFile, szTitle );
                statFile << "<tr bgcolor=\"#000000\">" << endl;
                statFile << "<td width=\"3\" align=\"center\">&nbsp;</td>" << endl;      /* Female?              */
                statFile << "<td width=\"3\" align=\"center\">&nbsp;</td>" << endl;      /* Alignment            */
                statFile << "<td width=\"30%\" align=\"left\">";
                htmlSetColor( &statFile, 0x00c800L );
                statFile << "<b>Name</b></font></td>" << endl;        /* Name of player       */
                statFile << "<td width=\"24%\" align=\"right\">";
                htmlSetColor( &statFile, 0x00c800L );
                statFile << "<b>Experience</b></font></td>" << endl; /* Experience of player */
                statFile << "<td width=\"15%\" align=\"right\">";
                htmlSetColor( &statFile, 0x00c800L );
                statFile << "<b>Level</b></font></td>" << endl;      /* Level of Player      */
                statFile << "<td width=\"15%\" align=\"center\">";
                htmlSetColor( &statFile, 0x00c800L );
                statFile << "<b>Quests</b></font></td>" << endl;     /* Quests Completed     */
                statFile << "<td width=\"10%\" align=\"center\">";
                htmlSetColor( &statFile, 0x00c800L );
                statFile << "<b>Status</b></font></td>" << endl;     /* Alive or Dead?       */
                statFile << "</tr>" << endl;
/*                statFile << "<tr bgcolor=\"#000000\">" << endl;
                statFile << "<td colspan=\"7\" align=\"center\" width=\"100%\">" << endl;
                statFile << "<font size=\"+1\"><tt>" << endl;
                htmlSetColor( &statFile, 0x009000L );
                statFile << "-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-" << endl;
                statFile << "</font></tt></font></td></tr>" << endl; */

                statFile.flush();
        }
        else
        {
                statFile.open( szStatFile, ios::app );
                if ( !statFile )
                {
                        cerr << "Unable to open " << szStatFile << " for output!" << endl;
                        return;
                }
                htmlStatClose( &statFile );
        }

        statFile.close();

}

