/*
     Copyright (c) 2000,2010 Michael Dillon

     Permission is hereby granted, free of charge, to any person obtaining a copy
     of this software and associated documentation files (the "Software"), to deal
     in the Software without restriction, including without limitation the rights
     to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
     copies of the Software, and to permit persons to whom the Software is
     furnished to do so, subject to the following conditions:
     
     The above copyright notice and this permission notice shall be included in
     all copies or substantial portions of the Software.
     
     THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
     IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
     FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
     AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
     LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
     OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
     THE SOFTWARE.
*/
#include <iostream>
#include <fstream>
#include <iomanip>
#include <cstdlib>
#include <cstdio>
#include <cerrno>
#include <cctype>
#include <ctime>
#include <cstring>

using namespace std;

#include "cstats.h"
#include "utilfunc.h"

/**************************************************************************
 * LEGEND OF THE RED DRAGON
 *
 * Specific functions that are for handling L.O.R.D. files
 **************************************************************************/
//int lordDelChk( const void *player )
int lordDelChk( lord_player_info *player )
{
//        lord_player_info *p = ( lord_player_info * )player;
//        if ( ( strnicmp( ( char * )&p->name[ 1 ], "X", p->name[ 0 ] ) == 0 ) )
        if ( ( strnicmp( ( char * )&player->name[ 1 ], "X", player->name[ 0 ] ) == 0 ) )
                return ( 1 );
#ifdef DEBUG
//        printf( "lordDelChk(): Not Deleted, address of p: %lu\n", (unsigned long)p );
//        printf( "lordDelChk(): Not Deleted, address of p: %lu\n", (unsigned long)player );
#endif
        return ( 0 );
}

//void lordAssign( SORT *psort, const void *object )
void lordAssign( SORT *psort, lord_player_info *object )
{
//        psort->Experience = ( ( lord_player_info * )object )->exp;
        psort->Experience = object->exp;
#ifdef DEBUG
//        printf( "lordAssign(): Experience: %lu\n", ( ( lord_player_info * )object )->exp );
        printf( "lordAssign(): Experience: %lu\n", object->exp );
#endif
}

int lordCompare( const void *p1, const void *p2 )
{
        SORT *lrdSort1 = ( SORT * )p1, *lrdSort2 = ( SORT * )p2;
#ifdef DEBUG
        printf( "lordCompare(): Player1 Experience: %10lu Player2 Experience: %10lu\n", ( ( SORT * )p1 )->Experience, ( ( SORT * )p2 )->Experience );
#endif
        if ( lrdSort1->Experience == lrdSort2->Experience )
                return ( 0 );
        if ( lrdSort1->Experience < lrdSort2->Experience )
                return ( 1 );
        else
                return ( -1 );
}

void lordHTML( int task )
{
        const char szStatFile[] = "lstat.htm";
        const char statTitle[] = "Legend Of the Red Dragon Player Statistics";
        ofstream   statFile;
        if ( task == 0 )
        {
                statFile.open( szStatFile );
                if ( !statFile )
                {
                        cerr << "Unable to open " << szStatFile << " for output." << endl;
                        return;
                }
                cout << "Writing the statistics to \"" << szStatFile << "\"..." << endl;
                htmlStatHeader( &statFile, statTitle );
                statFile << "<tr bgcolor=\"#0000a0\">" << endl;
                statFile << "<td width=\"3%\" algin=\"center\">&nbsp;</td>" << endl;
                statFile << "<td width=\"3%\" align=\"center\">&nbsp;</td>" << endl;
                statFile << "<td width=\"29%\" align=\"left\">Name</td>" << endl;
                statFile << "<td width=\"20%\" align=\"right\">Experience</td>" << endl;
                statFile << "<td width=\"10%\" align=\"right\">Level</td>" << endl;
                statFile << "<td width=\"15%\" align=\"right\">Mastered</td>" << endl;
                statFile << "<td width=\"15%\" align=\"center\">Status</td>" << endl;
                statFile << "</tr>" << endl;
        }
        else
        {
                statFile.open( szStatFile, ios::app );
                if ( !statFile )
                {
                        cerr << "Unable to open " << szStatFile << " for output." << endl;
                        return;
                }
                htmlStatClose( &statFile );
        }
        statFile.close();
}

void lordMasteryFrmt( ofstream *file, signed long int skill, signed long int fcolor, signed long int hcolor, char pclass )
{
        *file << "<td width=\"33%\">";
        if ( skill >= 40 )
        {
                htmlSetColor( file, fcolor );
                *file << pclass << "</font>" << endl;
        }
        else if ( skill > 20 && skill < 40 )
        {
                htmlSetColor( file, hcolor );
                *file << pclass << "</font>" << endl;
        }
        *file << "</td>" << endl;
        file->flush();
}

//void lordOutput( PRGSCAN *prgScan, const void *object )
void lordOutput( PRGSCAN *prgScan, lord_player_info *p )
{
        const char CLASS[] = "DMT";
        const signed long int CLASSCOLS[] = { 0x00f8ff, 0xf800f8, 0xf00000 };
//        lord_player_info *p = ( lord_player_info * )object;
        const char szStatFile[] = "lstat.htm";
        ofstream statFile( szStatFile, ios::app );
        if ( !statFile )
        {
                cerr << "Unable to open " << szStatFile << " for append/output." << endl;
                return;
        }
        statFile << "<tr bgcolor=\"#000000\">" << endl;
        /* Female or not? */
        statFile << "<td width=\"3%\" align=\"center\">" << endl;
#ifdef DEBUG
        printf( "lordOutput(): sex: %d\n", (int)p->sex );
#endif
        if ( p->sex == 5 )
        {
                htmlSetColor( &statFile, 0x00ff00L );
                statFile << "F" << "</font>" << endl;
        }
        statFile << "</td>" << endl;
        /* Current Class */
#ifdef DEBUG
        printf( "lordOutput(): Class: %d\n", (int)p->Class );
#endif
        statFile << "<td width=\"3%\" align=\"center\">" << endl;
        htmlSetColor( &statFile, CLASSCOLS[ ( p->Class ) - 1 ] );
        statFile << CLASS[ ( p->Class ) - 1 ] << "</font>" << endl << "</td>" << endl;
        /* Name */
        statFile << "<td width=\"29%\" align=\"left\">" << endl;
        statFile << sansirem( strptoc( ( char * )p->name ) ) << "</td>" << endl;
        /* Experience */
#ifdef DEBUG
        printf( "lordOutput(): Experience: %ld\n", p->exp );
#endif
        statFile << "<td width=\"20%\" align=\"right\">" << endl;
        htmlSetColor( &statFile, 0x00afafL );
        statFile << ultoac( (unsigned)p->exp ) << "</font></td>" << endl;
        /* Level */
#ifdef DEBUG
        printf( "lordOutput(): Level: %d\n", p->level );
#endif
        statFile << "<td width=\"10%\" align=\"right\">" << endl;
        statFile << p->level << "</td>" << endl;
        /* Mastered */
        statFile << "<td width=\"15%\" align=\"right\">" << endl;
        statFile << "<table width=\"50%\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\">" << endl;
        statFile << "<tr colspan=\"3\">" << endl;
        lordMasteryFrmt( &statFile, p->skillw, 0xffffffL, CLASSCOLS[ 0 ], CLASS[ 0 ] );
        lordMasteryFrmt( &statFile, p->skillm, 0xffffffL, CLASSCOLS[ 1 ], CLASS[ 1 ] );
        lordMasteryFrmt( &statFile, p->skillt, 0xffffffL, CLASSCOLS[ 2 ], CLASS[ 2 ] );
        statFile << "</tr>" << endl;
        statFile << "</table>" << endl << "</td>" << endl;
        /* Status */
        statFile << "<td width=\"15%\" align=\"center\">";
        if ( p->dead == 5 )
        {
                htmlSetColor( &statFile, 0xf00000L );
                statFile << "Dead" << "</font>" << endl;
        }
        else
        {
                statFile << "Alive" << endl;
        }
        statFile << "</td>" << endl;
        statFile << "</tr>" << endl;
        statFile.flush();
        statFile.close();
}

