/*
     Copyright (c) 2000,2010 Michael Dillon

     Permission is hereby granted, free of charge, to any person obtaining a copy
     of this software and associated documentation files (the "Software"), to deal
     in the Software without restriction, including without limitation the rights
     to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
     copies of the Software, and to permit persons to whom the Software is
     furnished to do so, subject to the following conditions:
     
     The above copyright notice and this permission notice shall be included in
     all copies or substantial portions of the Software.
     
     THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
     IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
     FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
     AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
     LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
     OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
     THE SOFTWARE.
*/
#if !defined( CSTATS__PRIMARY__HEADER___H )
#define CSTATS__PRIMARY__HEADER___H 1

/* Disable the "changed alignment warning in VC++" */
#if defined( _MSC_VER )
# pragma warning(disable:4103)
#endif

/* Include the game structures */
#include "lordstrc.h"
#include "l2strc.h"
#include "tstructs.h"
#include "avalon85.h"

/* Find Compile Target Type */
#if defined( WIN32 ) || defined( _MSC_VER )
# define COMPTYPE "Win32"
#elif defined( DJGPP )
# define COMPTYPE "DOS"
#elif defined( unix ) || defined( linux ) && !defined( DJGPP )
# define COMPTYPE "Linux"
#elif defined( OS2 )
# define COMPTYPE "OS/2"
#else
# define COMPTYPE "Unknown"
#endif


/* Undefine any prior definition of host type */
#if defined( __CSTATS_WINDOWS )
# undef __CSTATS_WINDOWS
#endif
#if defined( __CSTATS_POSIX )
# undef __CSTATS_POSIX
#endif
#if defined( __CSTATS_OS2 )
# undef __CSTATS_OS2
#endif

/* Define the host type */
#if defined( WIN32 ) || defined( _MSC_VER )
# define __CSTATS_WINDOWS 1
# define DIRSEPARATOR '\\'
#elif defined( unix ) || defined( linux ) || defined( DJGPP )
# define __CSTATS_POSIX 1
# define DIRSEPARATOR '/'
#elif defined( OS2 )
# define __CSTATS_OS2 1
# define DIRSEPARATOR '\\'
#else
# define DIRSEPARATOR '/'
#endif

#if defined( unix ) || defined( linux )
# define stricmp strcasecmp
# define strnicmp strncasecmp
#endif

/* Define the author and version information */
#define PRG_RELEASETYPE "" // release
#define PRG_NAME "CStats"
#define PRG_FULLNAME "Crystalline Stats"
#define PRG_AUTHOR "Michael Dillon"
#define PRG_VERSION "0.1.2.2" PRG_RELEASETYPE "-" COMPTYPE

/* Max size of path buffer */
#define CSTATS_MAX_PATH 4096

typedef struct {
        unsigned long int       Program;                    /* 1 = LORD, 2 = LORD2, 3 = TEOS */
        char                    PrgPath[ CSTATS_MAX_PATH ]; /* Path to program               */
} PRGSCAN, *LPPRGSCAN;

typedef struct {
        signed short int        Record;        /* Entry within the file itself           */
        signed long int         Experience;    /* Used for sorting, experience of player */
} SORT, *LPSORT;

typedef struct {
        void ( *htmlOutput )( int );
        int ( *Compare )( const void *, const void * );
        int ( *DeleteChk )( const void * );
        void ( *Assign )( SORT *, const void * );
        void ( *Output )( PRGSCAN *, const void * );
} FNDATA, *LPFNDATA;


/* function prototypes */
void Usage( void );
void ProcessCommandLine( int argc, char *argv[], LPPRGSCAN prgScan );
void ProcessPlayers( LPPRGSCAN prgScan );
//int ProcessPlayerData( PRGSCAN *, const char *, size_t, FNDATA * );

template <class OBJ> int ProcessPlayerData(
        PRGSCAN *prgScan,
        const char *szFileName,
        void ( *htmlOutput )( int ),
        int  ( *Compare )( const void *, const void * ),
        int  ( *DeleteChk )( OBJ * ),
        void ( *Assign )( SORT *, OBJ * ),
        void ( *Output )( PRGSCAN *, OBJ * ) );

void htmlStatHeader( ofstream *file, const char *szTitle );
void htmlStatClose( ofstream *file );
void htmlSetColor( ofstream *file, signed long int color );
void FixPath( char * );

/* Definition of the flags available in the command line,
 * this basically what flags will be used to denote games
 */
const char PRGFLAGS[][ 10 ] = { "-lord", "-lord2", "-teos", "-avln85" };
/* List of the names corresponding to each of the prior flags */
const char PRGNAMES[][ 50 ] = {
"Legend Of the Red Dragon", 
"Legend Of the Red Dragon 2",
"Planets: The Exploration Of Space",
"Avalon - Live The Epic" };

#endif
