
/*
            ۿ ۿ   ۿ ۿ ۿ       ۿ  ۿ  ۿ
            ۳ ۳   ۳ ۳ ۳      ۿ ۿ ۳
            ۳ ۳   ۳ ۳ ۳      ۳   ۳ ۿ۳
            ۳ ۿ  ۳ ۳      ۳   ۳ ۳۳
            ۳   ۳    ۳   ۳ ۿ  ۳ ۳
                               

 - Avalon Data File Structures                                                
 - Avalon is (C) 2000, Dean Woodside, of Auspisoft                            
 - Feel free to distribute to everyone!                                       
 - Create EGO's, Utilities, and more for Avalon!                              


Hello friend!                                                                

 I'm preparing this information file to help others in created 3rdParty stuff 
 for Avalon.  Feel free to charge anything you wish for your program(s) -- as 
 we do not charge any type of "royalty" fee on 3rdParty products.             

 Hey, you want to write an EGO?  Excellent!  It is really quite simple.  It's 
 basically a three step process, like this:                                   
                     1. Read in AVINFO.<x>, where <x> is the node number of   
                        the current online user.                              
                     2. Load up the PLAYER.DAT file, and find the player name 
                        that matches the name in the AVINFO.<x> file.         
                     3. That's it!  You're on your way -- start your program! 

 In an update to Avalon soon, we will try to include some sort of EGO devel-  
 opment kit to assist those who're experiencing troubles with their program   
 or programs.  Well, for now, though, you're on your own. <g>  

 ---- C/C++ Programmer's info ----
 To make EGOs you'll need a copy of OpenDoors or another C/C++ programming
 package in order to write doors and addons.

 You'll need a compiler capable of compiling OpenDoors and/or any other
 assisting package you may need.
 ---------------------------------

 All user variables in PLAYER.DAT are commented here for your convenience.

*/

/*
        Pascal structures converted to C format by Michael Dillon.
        C structures are Copyright (C) 2000 Michael Dillon.

        Tested With:    Visual C++ 4.0 Standard
                        DJGPP 2.952

        These structures should compile with even older compilers such
        as Borland C++ 3.1 or higher.  I have not tested the structures
        on those compilers.

        Items that will have a TRUE/FALSE meaning are marked with BOOL

        You must have a function that will convert the pascal strings to
        their C equivalents.
        
        When you compile, confirm these sizes:

        UserRecord : 240
        ShopData   : 25
        MentorData : 31
        MonData    : 33
        GuardData  : 16
        EGOData    : 297

        Converted on: May 17, 2000

        *** I, Michael Dillon, nor the author(s) of Avalon hold any
        *** responsibility of damages that incurr on your machine
        *** or others due to these structures.

        Visual C++ Copyright Microsoft Corp.
        Borland C++ Copyright Inprise Corp.
        DJGPP Copyright D.J. Delorie
*/

#if !defined( AVALON__STRUCTS )
#define AVALON__STRUCTS

/* Make sure the alignment is 1 */
#if defined( _WIN32 ) || defined( DJGPP ) || defined( unix )
# pragma pack( 1 )
#endif

typedef struct {
        char            Real_Name[ 41 ];   /* Player's Real Name from the BBS        */
        char            Alias[ 16 ];       /* User's game Alias in Avalon            */
        char            Date[ 21 ];        /* Date Flag -- User's last online date   */
        char            Arrived_At[ 11 ];  /* Time player entered (24 hour time)     */
        unsigned char   TimesOn;           /* # of time this player played Avalon    */
        unsigned char   Time_Zone;         /* Current Time Zone (1 = Medieval,
                                              2 = Present, 3 = Future, 4 = Avalon)   */
        unsigned char   Char_Class;        /* Player's Character Class (1 = Warrior,
                                              2 = Necromancer, 3 = Thief)            */
        char            Companion[ 21 ];   /* Current Companion of this character    */
        signed long int Hand;              /* Currency on Hand                       */
        signed long int Bank;              /* Currency head in the bank              */
        unsigned char   Bank_Ban;          /* How many days user cannot enter Bank   */
/*BOOL*/unsigned char   Bank_Rob;          /* Has user robbed bank already today?    */
        unsigned char   Gender;            /* Player's Gender (1 = Male, 2 = Female) */
/*BOOL*/unsigned char   Online;            /* If TRUE, player is currently online    */
        short int       Str;               /* Character's Strength Meter             */
        short int       Def;               /* Character's Defense Meter              */
        short int       Dex;               /* Character's Dexterity Meter            */
        short int       Wisdom;            /* Character's Wisdom Meter               */
        short int       Know;              /* Character's Knowledge Meter            */
        short int       HP;                /* Character's Current Health Points      */
        short int       HP_Max;            /* Character's Maximum Health Points      */
        short int       MP;                /* Character's Current Magic Points       */
        short int       MP_Max;            /* Character's Maximum Magic Points       */
        char            Weapon_Name[ 21 ]; /* Current Weapon Name                    */
        unsigned char   Weapon_Num;        /* Weapon Number (1..10)                  */
        char            Armour_Name[ 21 ]; /* Current Armour Name                    */
        unsigned char   Armour_Num;        /* Armour Number (1..10)                  */
        short int       Charisma;          /* Good looks meter                       */
        signed long int Exp;               /* Character's Experience Points          */
        short int       Level;             /* Current level the character is on      */
        unsigned char   Sleep;             /* Where player is sleeping (1 = Plains,
                                              2 = Inn, 3 = In an EGO)                */
        signed long int Invested;          /* Initial amount which was invested      */
        signed long int Projected;         /* Projected return on investment         */
        char            Invest_Date[ 21 ]; /* Date on which the investment was made  */
        unsigned char   Invest_Time;       /* How many days the investment was for   */
        unsigned char   Status;            /* Player Status (1 = Alive, 2 = Dead)    */
/*BOOL*/unsigned char   On_Today;          /* Has this user been on already today?   */
        short int       Arrows;            /* (NOT USED YET) Arrows on Hand          */
/*BOOL*/unsigned char   WS_Haggle;         /* Has user haggled in Weapon Shop?       */
/*BOOL*/unsigned char   AS_Haggle;         /* Has user haggled in Armour Shop?       */
/*BOOL*/unsigned char   Mentor_Fight;      /* Has user fought their Mentor today?    */
        short int       P_Fights;          /* Player fights remaining for today      */
        short int       M_Fights;          /* Monster fights remaining for today     */
        short int       Potions;           /* Healing Postions on this character     */
/*BOOL*/unsigned char   Elixir;            /* Has user bought and Elixir today?      */
} avln_UserRecord;


/* Here is the format of the Ownership Data File (PROPERTY.DAT). */

typedef struct {
        char            Owner[ 21 ];    /* Name of the owner of the property     */
        signed long int Price;          /* Price for another character to buy it */
} avln_ShopData;

/* Below is the format for the Mentors in Avalon (MENTORS.DAT). */

typedef struct {
        char            Name[ 21 ];     /* Mentor's Name                     */
        short int       Str;            /* Strength of attack from Mentor    */
        short int       Def;            /* Defensive skill of Mentor         */
        signed long int Exp;            /* Exp req. for user to fight Mentor */
        short int       HP;             /* Health Points of Mentor           */
} avln_MentorData;

/* And, the Monster Data File is below (MONSTERS.DAT). */

typedef struct {
        char            Name[ 21 ];     /* Name of the Monster              */
        short int       Str;            /* Strength of the Monster's Attack */
        signed long int Exp;            /* Experience reward when defeated  */
        short int       HP;             /* Health Points of the Monster     */
        signed long int Gold;           /* Currency reward when defeated    */
} avln_MonData;

/* Here we have the SNI Bank of Riches Guard Data File (SNIBANK.DAT). */

typedef struct {
        char            Name[ 16 ];    /* Name of the user who is has Guard Job */
} avln_GuardData;

/* And...finally, here is the format of the 3rd-Party EGO Data File (EGOS.DAT). */

typedef struct {
        char            EGO_Name[ 41 ];  /* Name of the EGO in this slot      */
        char            EGO_Path[ 256 ]; /* Path to the executable of the EGO */
} avln_EGOData;

/*
 SOME INFORMATION REGARDING EGO DEVELOPMENT:                                  
 When creating your EGO, keep these points in mind:          
                             1. A Maximum of 10 EGO's can be in the EGOS.DAT  
                                file.  When installing your EGO, check to see 
                                if 10 EGO's are already installed, to prevent 
                                possible mix-ups.                             
                             2. Please have an option for an uninstall of     
                                your EGO.  This must take out ALL the info    
                                that your installation procedure entered into 
                                the EGOS.DAT file.                            
                             3. One thing to remember upon installation of    
                                your EGO is to check if it's already been     
                                installed.  Always a good thing.              

 Upon Avalon's exit to run an EGO, AVINFO.<x> is created, where <x> is the    
 node number that the user is on.  AVINFO.<x> is a drop file.  As your EGO is 
 loading up, if need be, you might want to read in the AVINFO.<x> file. Below 
 is the format for this file:                                                 

      Line 1 ---> Record Number of the user in the PLAYER.DAT file            
      Line 2 ---> Graphics Code.  3 = ANSI Graphics, else ASCII.              
      Line 3 ---> Time remaining online                                       
      Line 4 ---> ROK Alias of the character                                  
      Line 5 ---> First *REAL* Name of the user                               
      Line 6 ---> Last *REAL* Name of the user                                
      Line 7 ---> Com Port the modem is running on                            
      Line 8 ---> Actual Baud Rate                                            
      Line 9 ---> Locked Baud Rate                                            

 That is the format of the AVINFO.<x> file.  A 9-Line drop file format.

 Well, that's all of them!  As mentioned above, if you require assistance in  
 regards to the structs shown here, please feel free to contact us anytime.   
*/


#endif
