(****************************************************************************

                        InterStellar Annihilation (ISA)
                                ISA IGM - Setup
                      Copyright(c) 2001-2002 Andy Stewart

Version  : 0.994
Compiler : Turbo Pascal 7.0
Updated  : 11.12.02

 ****************************************************************************)
Program ISA_IGM_Config;

uses
  Dos,
  Crt;

{.$APPTYPE CONSOLE}
{ Define this if compiling under Delphi }

{$M 32768,0,100000}
{ REM this out if compiling under Delphi }

{.$DEFINE HUGESTR}
{ Define this if using HugeString in Project options - Delphi}

type
  IGMInfoRecord = Record
  Name,
  Author,
  Copyright,
  Version,
  EXEName,
  Directory     : String;
end;

var
  ISAPath     : String;
  InstallMode : Boolean;
  IGM         : IGMInfoRecord;


function CharStr(ch: char; i: byte): string;
{ Returns a string consisting of 'i' amount of 'ch' characters }
var
 i1: byte;
 s: string;

begin
 s:='';
 for i1:=1 to i do s:=s+ch;
 {aWrite(s);}
 charstr:=s;
end;


procedure BannerLine(s: string; f, b: byte);
{ Writes a 80 character banner with 's' centered }
{ 'f' = Foreground color, 'b' = Backgound color  }
var
 f1, b1,
 halfpadlen, halflen: byte;
 Pad: string[40];

begin
  f1 := textattr mod 16;
  b1 := textattr div 16;
  TextColor(f);
  TextBackground(b);
  halflen := length(s) div 2;
  halfpadlen := 37 - halflen;
  Pad := charstr(#32,halfpadlen);
  Write(#178#177#176 + Pad + s + pad);
  if odd(length(s)) then Write(#8);
  Writeln(#176#177#178);
  GotoXY(wherex,wherey - 1);
  TextColor(f1);
  TextBackground(b1);
end;



function FileExist(FileName : String) : Boolean;
{ Does the file exist? }

Var
  DirInfo : SearchRec;
begin
  FindFirst(FileName, AnyFile, DirInfo);
  if (DosError = 0) then
    FileExist := True
  else
    FileExist := False;
end;


function DirExist(st_Dir : DirStr) : Boolean;
{ Does the directory exist? }
Var
  wo_Fattr : Word;
  fi_Temp  : File;
begin
  assign(fi_Temp, (st_Dir + '.'));
  getfattr(fi_Temp, wo_Fattr);
  if (Doserror <> 0) then
    DirExist := False
  else
    DirExist := ((wo_Fattr and directory) <> 0);
end;

Function UpCaseStr(S:String): String; (* Returns String in Upper Case *)
Var
 I: Integer;

Begin
 For I := 1 to Length(S) Do
   S[I] := UpCase(S[I]);
 UpCaseStr := S;
End; { UpCaseStr }


Procedure FixPath (Var P:String;Var Ok:Boolean);
{ Add trailing \ if needed }
begin
 If (P[Length(P)] <> '\') Then P := P + '\';
 P := UpCaseStr(P);
 if DirExist(P) then OK := true else OK := false;
end;


Procedure DeleteFile(S: String);
{ Delete a file }
Var
 F: Text;

Begin
 If Not FileExist(S) Then Exit;
 Assign(F,S);
 SetFAttr(F,0);
 {$I-} Erase(F); {$I+}
 If IOResult<>0
  Then {} ;
End; { Delete File }


Procedure CopyFile(OrigFile, DestFile: String;Var Code:Byte);
{ Copy a file }
Var
 FromF,ToF: File;
 NumRead, NumWritten: Integer;
 Buf: Array[1..2048] of Char;
 OrigFileSize,
 DestFileSize: LongInt;
 Ok: Boolean;
 S: String;
 FileAttr: Word;
 FileTime: LongInt;
Begin
 Code:=0;
 If Not FileExist(OrigFile) Then Begin Code:=1; Exit; End;

 Assign(FromF,OrigFile);
 Assign(ToF,DestFile);

 GetFAttr(FromF,FileAttr); { Get Info before opening file }
 GetFTime(FromF,FileTime);

 Reset(FromF,1);
 {$I-} Rewrite(ToF,1); {$I+}
 If IOResult<>0 Then Begin Code:=2; Close(FromF); Exit; End;
 OrigFileSize:=FileSize(FromF);
 (*
 WriteLn('Copying ',CapitalizeStr(OrigFile,[':','\','.']),' => ',
           CapitalizeStr(DestFile,[':','\','.']));
 *)
 Repeat
   BlockRead(FromF,Buf,SizeOf(Buf),NumRead);
   BlockWrite(ToF,Buf,NumRead,NumWritten);
 Until (NumRead=0) or (NumWritten<>NumRead);

 If NumWritten<>NumRead
  Then Begin
   Code:=3;
   Close(FromF);
   Close(ToF);
   Exit;
  End;
 DestFileSize:=FileSize(ToF);
 If DestFileSize<>OrigFileSize
  Then Begin
   Code:=3;
   Close(FromF);
   Close(ToF);
   Exit;
  End;
 Close(FromF);
 Close(ToF);
 SetFAttr(ToF,FileAttr);
 SetFTime(ToF,FileTime);
End; { Copy File }


Procedure MoveFile(OrigFile,Dest: String;Var Code:Byte);
{ Move a file }
Var
  N: NameStr;
  E: ExtStr;
  Ok: Boolean;
  F: Text;
  S: String;
  D, OrigDir: DirStr;
  DirInfo: SearchRec;
  P, FileToMove: PathStr;
  B: Byte;

begin
  Code := 0;
  if not FileExist(OrigFile) then
    begin
      Code := 4;
      exit;
    end;
  if Dest = '' Then Dest := '.';
  if (Length(Dest) <> 2) or
     (not (UpCase(Dest[1]) in ['A'..'Z'])) or
     (Dest[2] <> ':') then FixPath(Dest,Ok)
       else Ok := True;
  if not Ok then
    begin
      Code := 1;
      exit;
    end;
  P := OrigFile;
  FSplit(P,D,N,E);
  OrigDir := D;
  FindFirst(OrigFile,Archive,DirInfo);

 while DosError = 0 do
   begin
     P := OrigDir + DirInfo.Name;
     FileToMove := FExpand(P);
     S := FileToMove;
     Assign(F,S);
     {$I-} Rename(F,Dest + DirInfo.Name); {$I+}
     case IOResult of
(*    0 : WriteLn('Moving ',CapitalizeStr(S,[':','\','.']),' -> ',
           CapitalizeStr(Dest,[':','\','.'])); *)
       5 : begin
             Code := 2;
             exit;
           end;
      17 : begin
            CopyFile(S,Dest + DirInfo.Name,B);
            if B <> 0 then
              begin
                DeleteFile(Dest + DirInfo.Name);
                Code := 3;
                exit;
              end;
   (*      WriteLn('Deleting ',CapitalizeStr(S,[':','\','.'])); *)
            DeleteFile(OrigDir + DirInfo.Name);
          end;
    end; { Case }

   FindNext(DirInfo);
  end { While }
end; { Move File }


Procedure MakeDirectories;
begin
  if not DirExist(ISAPath + 'IGMS') then mkdir(ISAPath + 'IGMS');
  if not DirExist(ISAPath + 'IGMS\' + IGM.Directory) then
    mkdir(ISAPath + 'IGMS\' + IGM.Directory);
end;


Procedure GetISAPath;
var
  OK : boolean;
begin
  TextColor(15);
  write(' ');
  TextColor(7);
  writeln('Enter FULL path to your ISA Directory');
  writeln('  IE:  C:\SBBS\DOORS\ISA\');
  TextColor(15);
  write('   ');
  TextColor(7);
  readln(ISAPath);
  if ISAPath = '' then
    begin
      TextColor(14);
      Write('! ');
      TextColor(7);
      writeln('Aborted.');
      halt;
    end;

  FixPath(ISAPath,OK);
  if not DirExist(ISAPath) then
    begin
      TextColor(14);
      write('! ');
      TextColor(7);
      writeln('Path : ' + ISAPath + ' does not exist.  Please install ISA');
      writeln('  and/or check your paths.  Halting program.');
      Halt;
    end;
end;


Procedure MakeIGMDATFile;
var
  IGMDatFile : text;

begin
  assign(IGMDatFile,ISAPath + 'DATA\ISAIGM.DAT');
  rewrite(IGMDatFile);
  writeln(IGMDatFile,'; ISAIGM.DAT - This file controls the display of IGMs within ISA.');
  writeln(IGMDatFile,'; Copyright(c) 2001-2002 Andy Stewart.');
  writeln(IGMDatFile,'; ');
  writeln(IGMDatFile,'; The format is IGM Name,IGM EXE. IE:');
  writeln(IGMDatFile,'; ');
  writeln(IGMDatFile,'; IGM Name,IGM.EXE');
  writeln(IGMDatFile,'; ');
  writeln(IGMDatFile,'; Any lines with a semi-colon are comments and will be ignored.');
  writeln(IGMDatFile,'; ');
  close(IGMDatFile);
end;

procedure EditIGMDat;
var
  TempDatFile,
  IGMDatFile: text;
  IGMCount  : byte;
  IGMStr    : string;

begin
  IGMCount := 0;
  if not DirExist(ISAPath + 'DATA\') then
    begin
      writeln;
      TextColor(14);
      write('! ');
      TextCOlor(7);
      writeln('Error: ' + ISApath + 'DATA\ does not exist.');
      TextColor(14);
      write('!');
      TextColor(7);
      writeln('        Create this directory and re-run IGMCFG.EXE.');
      Halt;
    end;
  assign(IGMDatFile, ISAPath + 'DATA\ISAIGM.DAT');
  if not FileExist(ISAPath + 'DATA\ISAIGM.DAT') then MakeIGMDATFile;
  reset(IGMDatFile);
  if InstallMode then
    begin
      while not eof(IGMDatFile) do
        begin
          readln(IGMDatFile, IGMStr);
          if pos(IGM.EXEName,IGMStr) <> 0  then
            begin
              Close(IGMDatFile);
              exit;
            end;
        end;
    end
  else
    begin
      assign(TempDatFile, ISAPath + 'DATA\ISAIGM.TMP');
      rewrite(TempDatFile);
      while not eof(IGMDatFile) do
        begin
          readln(IGMDatFile, IGMStr);
          if pos(IGM.EXEName,IGMStr) = 0  then
          writeln(TempDatFile,IGMStr);
        end;
      close(TempDatFile);
      close(IGMDatFile);
      DeleteFile(ISAPath + 'DATA\ISAIGM.DAT');
      Rename(TempDatFile, ISAPath + 'DATA\ISAIGM.DAT');
      Exit;
    end;
  close(IGMDatFile);
  append(IGMDatFile);
  writeln(IGMDatFile,';');
  writeln(IGMDatFile,IGM.Name + ',' + IGM.Directory + '\' + IGM.EXEName);
  Close(IGMDatFile);
end;


Procedure CopyNeededFiles;
{ This is where you will add additional files to be copied (Docs, ANSIs, etc) if needed.
  Simply cut 'n paste the below code to copy any additional files. }
var
  Result: byte;

begin
  { Copy IGM.EXEName }
  if (not FileExist(ISAPath + 'IGMS\' + IGM.Directory + '\' + IGM.EXEName)) and (FileExist(IGM.EXEName)) then
    begin
      TextColor(15);
      Write(' ');
      TextColor(7);
      writeln('Copying ' + IGM.EXEName + '.');
      CopyFile(IGM.EXEName,ISAPath + 'IGMS\' + IGM.Directory + '\' + IGM.EXEName,Result);
      If Result <> 0 then
        begin
          writeln;
          TextColor(14);
          write('! ');
          TextColor(7);
          writeln('Error : Cannot copy ' + IGM.EXEName + ' to ' + ISAPath + 'IGMS\' + IGM.Directory + '\.');
          TextColor(14);
          write('! ');
          TextColor(7);
          writeln('        You must manually copy it.');
          writeln;
        end;
    end;
end;


Procedure RemoveFiles;
var
  Result: byte;

begin
  { Delete IGM.EXEName and IGM.Directory Subdirectory}
  if (not FileExist(ISAPath + 'IGMS\' + IGM.Directory + '\' + IGM.EXEName)) then
    begin
      TextColor(14);
      Write('! ');
      TextColor(7);
      writeln(ISAPath + 'IGMS\' + IGM.Directory + '\' + IGM.EXEName + ' does not exist.');
      halt;
    end
  else
    begin
      TextColor(15);
      Write(' ');
      TextColor(7);
      writeln('Removing ' + IGM.EXEName + '.');
      DeleteFile(ISAPath + 'IGMS\' + IGM.Directory + '\' + IGM.EXEName);
      TextColor(15);
      Write(' ');
      TextColor(7);
      writeln('Removing ' + IGM.Directory + ' subdirectory.');
      RMDir(ISAPath + 'IGMS\' + IGM.Directory);
   end;
end;


procedure ReadConfigFile;
var
  CfgFile : Text;

begin
  if not FileExist('IGMCFG.DAT') then
    begin
      writeln;
      TextColor(14);
      write('! ');
      TextColor(7);
      writeln('Error:  Configuration file (IGMCFG.DAT) not found, halting.');
      writeln;
      Halt;
    end;
  Assign(CfgFile,'IGMCFG.DAT');
  Reset(CfgFile);
  Readln(CfgFile,IGM.Name);
  Readln(CfgFile,IGM.Author);
  Readln(CfgFile,IGM.Copyright);
  Readln(CfgFile,IGM.Version);
  Readln(CfgFile,IGM.EXEName);
  Readln(CfgFile,IGM.Directory);
  Close(CfgFile);
end;

Procedure Intro;
begin
  TextColor(7);
  TextBackground(0);
  ClrScr;
  BannerLine('ISA IGM Setup - Copyright (c) 2001-2002 Andy Stewart',15,4);
  writeln;
  writeln;
  TextColor(15);
  write(' ');
  TextColor(7);
  writeln(IGM.Name + ' Setup ' + IGM.Version + ' - ' + IGM.Copyright);
  if (ParamStr(1) = '/U') or (ParamStr(1) = '/u') then InstallMode := False
     else InstallMode := True;
  TextColor(15);
  write(' ');
  TextColor(7);
  if InstallMode then writeln('Installation Mode')
    else writeln('Uninstall Mode');
  writeln;
end;


BEGIN
  ReadConfigFile;
  Intro;
  GetISAPath;
  if InstallMode then
    begin
      MakeDirectories;
      EditIGMDat;
      CopyNeededFiles;
    end
  else
    begin
      EditIGMDat;
      RemoveFiles;
    end;
  writeln;
  TextColor(14);
  write(' ');
  TextColor(7);
  writeln('Done!');
  writeln;
  writeln;
END.