(****************************************************************************

                        InterStellar Annihilation (ISA)
                       Spider's Realm IGM - Comments Unit
                      Copyright(c) 1996-2002 Andy Stewart

Version  : 0.994
Compiler : Turbo Pascal 7.0
Updated  : 11.12.02

 ****************************************************************************)

unit comments;

INTERFACE

uses
 Angel,         { Doorkit }
 aISA,          { Read/Write USER????.IN/OUT routines }
 Crt;           { Duh! }

Procedure RunComments;

IMPLEMENTATION

Procedure AddComment(CmtStr: string);
{ Add a comment to the comment file }
var
  CommentFile : Text;

begin
  assign(CommentFile,'DATA\SPDRCMT.DAT');
  if not FileExist('DATA\SPDRCMT.DAT') then rewrite(CommentFile)
    else append(CommentFile);
  writeln(CommentFile,CmtStr);
  close(CommentFile);
end;

Procedure ShowComments;
{ Show the comment file }
var
  CommentFile: text;
  Loop : byte;
  TmpStr: string;

begin
  assign(CommentFile,'DATA\SPDRCMT.DAT');
  reset(CommentFile);
  Loop := 0;
  DrawStars;
  while not eof(CommentFile) do
    begin
      inc(Loop);
      readln(CommentFile,TmpStr);
      aWriteICCln(TmpStr);
      if Loop > 20 then
        begin
          Loop := 0;
          newpause;
          DrawStars;
        end;
    end;
  close(CommentFile);
end;


Procedure MakeCommentFile;
{ Make the comment file }
begin
  AddComment('^\01'+charstr('',79));
  AddComment('^\01   ^\03Spider^\0B''^\03s Realm Comments^\01 ');
  AddComment('^\01'+charstr('',79));
  AddComment('');
end;

Procedure GetComment;
{ Get the comment from the user }
var
  SEL: char;
  Cmt: string;

begin
  newlnn(2);
  aWriteICC('^\0F  ^\03Your Comment ^\0B: ^\0B');
  GInput2(Cmt,55,#176,'Abort!');
  if Cmt <> '' then
    begin
      AddComment('^\0F ^\09' + ISAUser.Alias);
      AddComment('^\0F- ^\03' + Cmt);
      AddComment('');
      newlnn(2);
      aWriteICCln('^\03You wrote the following^\0B:^\LF');
      aWriteICCln('^\0F ^\09' + ISAUser.Alias);
      aWriteICCln('^\0F- ^\03' + Cmt);
      newln;
      newpause;
    end;
end;


Procedure RunComments;
{ Displays the comments, then asks the user it he/she would like to add one }
var
  SEL: char;
  CmtStr: string;

begin
  DrawStars;
  if not FileExist('DATA\SPDRCMT.DAT') then MakeCommentFile;
  ShowComments;
{  aShowFile('DATA\SPDRCMT.DAT',3,0,True,False);}
  newln;
  aWriteICC('^\0F  ^\03Add a comment ^\0B[^\09Y^\0B/^\09n^\0B] : ^\09');
  OneChar(SEL,'YN'+#10#13);
  case SEL of
    'N': begin
           aWriteICCln('^\09No');
           delay(250);
           exit;
         end;
    #10,
    #13,
    'Y': begin
           aWriteICCln('^\09Yes');
           delay(250);
           GetComment;
         end;
  end; { case }
end;

END. { COMMENTS.PAS }
