{Unit with KDRIVE commands for compatibility to ANGEL doorkit!

 Written by Charlie Wardick and provides "AS IS" and no support
 can be expected, however feel free to ask via email and if I
 can afford the time I will assist

 Feel free to modify this unit to you own taste. If you correct
 any bugs or add additional KDRIVE specific items please contact
 me and/or Jimmy Rose so that this unit supplied with the Angel
 doorkit can be updated and re-released as needed with future
 Angel versions

 I can be contacted at chasware@cox.net and
 Jimmy Rose can be contacted at atlantis@jimmyrose.com

 Good luck and happy coding! }



UNIT AngelKD;
INTERFACE
USES DOS;

TYPE      Str2 = STRING[2];

CONST     UseLordColors:BOOLEAN = False; {Used for Lord type colors `1 `2, etc}

{02/18/02}FUNCTION  AddBack(DirName:STRING):STRING;{adds backslash to string if it doesn't have one}
{02/18/02}FUNCTION  DoorDir:PathStr;               {path the program we are running is located}
{02/18/02}FUNCTION  GetRandNum(LoNum,HiNum:LongInt):LongInt;{Returns a random number between hi/low}
{02/18/02}FUNCTION  NoBack(TempStr1:STRING):STRING;{removes backslash from string if it has one}
{02/18/02}FUNCTION  NoCol(S:STRING):STRING;{strips lord and kdrive color codes from string}
{02/18/02}FUNCTION  S2U(Str:STRING):STRING;{upper case and entire string}

{02/18/02}PROCEDURE ClearRegion(x,y1,y2:Byte);{clears are of screen start at x, y1 to y2 }
{02/18/02}PROCEDURE Cwrite(S:STRING);         {awrite with kdrive embbed codes}
{02/18/02}PROCEDURE CwriteC(Str:STRING);      {awrite(center) with kdrive embbed codes}
{02/18/02}PROCEDURE Cwriteln(S:STRING);       {awriteln with kdrive embbed codes}
{02/18/02}PROCEDURE CWritelnC(Str:STRING);    {awriteln(center) with kdrive embbed codes}
{02/18/02}PROCEDURE CwriteXY(x,y:BYTE;s:STRING);{{awritXY with kdrive embbed codes}
{02/18/02}PROCEDURE Prompt(VAR S:STRING;LE:Integer;PC:Boolean);{kdrive compatible prompt string}
{02/18/02}PROCEDURE SetColor(Color:Str2);     {sets both forground and background colors}
{02/18/02}PROCEDURE WaitC;                    {kdrive compatible pause}


IMPLEMENTATION
USES CRT, Angel;

FUNCTION AddBack(DirName:STRING):STRING;
CONST DosDelimSet : SET OF Char = ['\', ':', #0];
BEGIN
  IF DirName[Length(DirName)] IN DosDelimSet THEN AddBack := DirName ELSE AddBack := DirName+'\';
END;{AddBack}

FUNCTION  NoBack(TempStr1:STRING):STRING;
VAR TempStr2:STRING;
BEGIN
  TempStr2:=TempStr1;
  IF (TempStr2[Length(TempStr2)]='\')THEN Delete(TempStr2,Length(TempStr2),1);
  NoBack:=TempStr2;
END;{NoBack}

FUNCTION  DoorDir:PathStr;
VAR D: DirStr;N: NameStr;E: ExtStr;
BEGIN
  FSplit(ParamStr(0),D,N,E);
  DoorDir:=NoBack(D);
END;{DoorDir}

PROCEDURE Prompt(VAR S:STRING; LE:Integer; PC:Boolean);
VAR  code : Integer;
    x,y,a,fg,bg : Byte;
    ch : Char;
    s2 : STRING;
    FirstWrt:Boolean;
BEGIN
  S2:=S;
  fg:=aGetFore;
  bg:=aGetBack;
  FirstWrt:=True;
  x:=WhereX;
  y:=WhereY;
  IF pc THEN aSetColor(7,1);{}
  FOR a:=1 TO le DO aWrite(' ');
  aGotoxy(x,y);
  aWrite(s2);
  aGotoxy(x,y);
  s:='';
  REPEAT
    ch:=areadkey;
    IF (ch<>#8) AND (ch<>^M) AND (Length(s)<le) THEN
    BEGIN
      IF FirstWrt THEN
      BEGIN
        FOR a:=1 TO le DO aWrite(' ');
        FOR a:=1 TO le DO aWrite(#8);
        FirstWrt:=False;
      END;
      s:=s+ch;
      aWrite(ch);
    END;
    IF Length(s)>200 THEN Delete(s,1,1);
    IF (ch=chr(8)) AND (Length(s)>0) THEN
    BEGIN
      Delete(s,Length(s),1);
      aWrite(chr(8));
      aWrite(' ');
      aWrite(#8);
    END;
  UNTIL (ch=^M) OR (Length(s)=999);
  IF pc THEN BEGIN
    aSetColor(15,bg);
    WHILE WhereX>x DO aWrite(#8);
    IF (S='') THEN BEGIN
      aWrite(s2);
      s:=s2;
    END ELSE aWrite(s);
  WHILE WhereX<x+le DO aWrite(' ');
    aSetFore(fg);
  END;
  aWriteLn('');
END;{Prompt}

FUNCTION  Lord2KDC(S:STRING):STRING; {converts lord type colors `1 `2 to Kdrive embedded colors}
VAR a:Byte;
    NewStr:STRING;
BEGIN
  Lord2KDC:='';
  NewStr:='';
  IF (Pos('`',S)>0) THEN
  BEGIN
    FOR a:=1 TO Length(s) DO
    BEGIN
      IF S[a]='`' THEN
      BEGIN
        CASE UpCase(S[a+1]) OF
          #49 : BEGIN NewStr:=NewStr+'C01';A:=A+1;END;
          #50 : BEGIN NewStr:=NewStr+'C02';A:=A+1;END;
          #51 : BEGIN NewStr:=NewStr+'C03';A:=A+1;END;
          #52 : BEGIN NewStr:=NewStr+'C04';A:=A+1;END;
          #53 : BEGIN NewStr:=NewStr+'C05';A:=A+1;END;
          #54 : BEGIN NewStr:=NewStr+'C06';A:=A+1;END;
          #55 : BEGIN NewStr:=NewStr+'C07';A:=A+1;END;
          #56 : BEGIN NewStr:=NewStr+'C08';A:=A+1;END;
          #57 : BEGIN NewStr:=NewStr+'C09';A:=A+1;END;
          #48 : BEGIN NewStr:=NewStr+'C0A';A:=A+1;END;
          #33 : BEGIN NewStr:=NewStr+'C0B';A:=A+1;END;
          #64 : BEGIN NewStr:=NewStr+'C0C';A:=A+1;END;
          #35 : BEGIN NewStr:=NewStr+'C0D';A:=A+1;END;
          #36 : BEGIN NewStr:=NewStr+'C0E';A:=A+1;END;
          #37 : BEGIN NewStr:=NewStr+'C0F';A:=A+1;END;
          'B' : a:=a+1;
          #96 : NewStr := NewStr+s[a];
          ELSE NewStr:=NewStr+s[a];
        END;
        IF (a>=Length(s)) THEN
        BEGIN
          Lord2KDC:=NewStr;
          Exit;
        END;
      END ELSE NewStr:=NewStr+s[a];
    END;
  END ELSE NewStr:=S;
  Lord2KDC:=NewStr;
END;{Lord2KDC}

PROCEDURE WaitC;
BEGIN
  aGotoXY(33,WhereY);
  Pause(1);
END;

PROCEDURE ClearRegion(x,y1,y2:Byte);
VAR i:Byte;
BEGIN
  FOR i:=y1 TO y2 DO
   BEGIN
     aGotoXY(X,i);
     aClrEol;
  END;
END;

FUNCTION H2N(Hex:Char):Byte;
BEGIN
  CASE Upcase(Hex) OF
   '0' : H2N:=00;
   '1' : H2N:=01;
   '2' : H2N:=02;
   '3' : H2N:=03;
   '4' : H2N:=04;
   '5' : H2N:=05;
   '6' : H2N:=06;
   '7' : H2N:=07;
   '8' : H2N:=08;
   '9' : H2N:=09;
   'A' : H2N:=10;
   'B' : H2N:=11;
   'C' : H2N:=12;
   'D' : H2N:=13;
   'E' : H2N:=14;
   'F' : H2N:=15;
   ELSE H2N:=0;
  END;
END;

PROCEDURE Setcolor(Color:Str2);
VAR SF,SB:Byte;
BEGIN
  SB:=H2N(Color[1]);
  SF:=H2N(Color[2]);
  IF (SB>7) THEN BEGIN
    SB:=SB-8;
    SF:=SF+128;
  END;
  aSetFore(SF);
  aSetBack(SB);
END;

FUNCTION  KDC(S:STRING):STRING;{does the kdrive embedded colors and other}
VAR a:Byte;
    XStr:STRING;
BEGIN
  XStr:='';
  IF UseLordColors THEN S:=Lord2KDC(S);
  FOR a:=1 TO Length(s) DO
  BEGIN
    IF (S[a]='') THEN
    BEGIN
      IF (a>=Length(s)) THEN Exit;
      CASE UpCase(S[A+1]) OF
        'B' : BEGIN aSetBack(H2N(S[A+2]));A:=a+2;END;
        'C' : BEGIN SetColor(S[a+2]+S[a+3]);A:=A+3;END;
        'F' : BEGIN aSetFore(H2N(S[A+2]));A:=a+2;END;
        'W' : BEGIN aClr;A:=A+1;END;
        'X' : BEGIN aGotoXY(Str2Int(S[A+2]+S[A+3]),WhereY);A:=A+3;END;
        'Y' : BEGIN aGotoXY(WhereX,Str2Int(S[A+2]+S[A+3]));A:=A+3;END;
        'Z' : BEGIN aClrEol;A:=A+1;END;
      END;
    END ELSE {CharOut(S[a]);{} aWrite(s[a]);
  END;
  KDC:=XStr;
END;

PROCEDURE Cwrite(S:STRING);
BEGIN
  aWrite(KDC(s));
END;
PROCEDURE CwriteXY(x,y:BYTE;S:STRING);
BEGIN
  aGotoXY(x,y);
  aWrite(KDC(s));
END;

FUNCTION NoCol(S:STRING):STRING;{strips lord and kdrive colors}
VAR a:Byte;
    NewStr:STRING;
BEGIN
  IF UseLordColors THEN S:=Lord2KDC(S);
  NoCol:='';
  NewStr:='';
  IF (Pos('',S)>0) THEN
  BEGIN
    FOR a:=1 TO Length(s) DO
    BEGIN
      IF (S[a]='') THEN
      BEGIN
        CASE S[a+1] OF
          'B' : A:=A+3;
          'C' : A:=A+4;
          'F' : A:=A+3;
          'W' : A:=A+2;
          'X' : A:=A+4;
          'Y' : A:=A+4;
          'Z' : A:=A+2;
        END;
      END;
      NewStr:=NewStr+S[a];
      IF (a>=Length(s)) THEN
      BEGIN
        NoCol:=NewStr;
        Exit;
      END;
    END;
  END ELSE NewStr:=S;
  NoCol:=NewStr;
END;

PROCEDURE CwriteC(Str:STRING);
VAR NoC:STRING;
BEGIN
  NoC:=NoCol(Str);
  aGotoXY(40-(Length(NoC) DIV 2),WhereY);
  aWrite(KDC(Str));
END;

PROCEDURE Cwriteln(S:STRING);
BEGIN
  aWriteln(KDC(s));
END;

PROCEDURE CWriteLnC(Str:STRING);
VAR NoC:STRING;
BEGIN
  NoC:=NoCol(Str);
  aGotoXY(40-(Length(NoC) DIV 2),WhereY);
  aWriteLn(KDC(Str));
END;

FUNCTION  GetRandNum(LoNum,HiNum:LongInt):LongInt;
VAR TempNum:LongInt;
BEGIN
  REPEAT
    TempNum:=Random(HiNum);
  UNTIL (TempNum>=LoNum) AND (TempNum<=HiNum);
  GetRandNum:=TempNum;
END;

FUNCTION  S2U(Str:STRING):STRING;
VAR  i : Integer;
BEGIN
   FOR i:=1 TO Length(Str) DO Str[i]:=UpCase(Str[i]);
   S2U := Str;
END; { S2U }

FUNCTION N2H(Num:Byte):Char;
BEGIN
  CASE Num OF
   00 : N2H:='0';
   01 : N2H:='1';
   02 : N2H:='2';
   03 : N2H:='3';
   04 : N2H:='4';
   05 : N2H:='5';
   06 : N2H:='6';
   07 : N2H:='7';
   08 : N2H:='8';
   09 : N2H:='9';
   10 : N2H:='A';
   11 : N2H:='B';
   12 : N2H:='C';
   13 : N2H:='D';
   14 : N2H:='E';
   15 : N2H:='F';
   ELSE N2H:='0';
  END;{ N2H }
END;



BEGIN
END.