{Unit to act as IGM interface the the lord player.dat when using
 the Angel doorkit.

 Written by Charlie Wardick and provides "AS IS" and no support
 can be expected, however feel free to ask via email and if I
 can afford the time I will assist

 SPECIAL NOTE : Please note that CheckInt and CheckLongInt use
 the real value of integer and longint.  Some version of Lord
 cap these values at 32000 and 2000000000 respectively so I
 advise caution to either change the checked values to match the
 lord version via specific lord version code or change the
 functions themselves since my testing with range values in current
 version of lord produced some very bad results.

 ANOTHER NOTE : If using this UNIT in conjunction with AngelKD it
 should not be necessary to use the LWRITE procedures.  My USES
 statment from the Angel version of the Changeling is:
 USES CRT,DOS, LordIGM, ChasMisc, aLord, AngelKD, Angel;  Using in
 this order with KDrive compatibility unit AngelKD doesn't require
 using LWRITE procedures, not sure if swapping around unit names
 in the USES statement will have any effect.  LWRITE exist for
 the purpose of having lord color write commands in the event you
 are not using AngelKD and working strictcy with an Angel doorkit
 based Lord IGM.


 Feel free to modify this unit to you own taste. If you correct
 any bugs or add additional LORD specific items please contact
 me and/or Jimmy Rose so that this unit supplied with the Angel
 doorkit can be updated and re-released as needed with future
 Angel versions

 I can be contacted at chasware@cox.net and
 Jimmy Rose can be contacted at atlantis@jimmyrose.com

 Good luck and happy coding! }




UNIT aLord;

{$DEFINE LORDIGM} {JR}

INTERFACE

TYPE Lord_Info = RECORD
       names      : STRING[20];  {player handle in the game}
       real_names : STRING[50];  {real name/or handle from BBS}
       hit_points : Integer;     {player hit points}
       bad        : Integer;     {don't know - might not be used at all}
       rate       : Integer;     {again, couldn't find this one in the source}
       hit_max    : Integer;     {hit_point max}
       weapon_num : Integer;     {weapon number}
       weapon     : STRING[20];  {name of weapon}
       seen_master: Integer;     {equals 5 if seen master, else 0}
       fights_left: Integer;     {forest fights left}
       human_left : Integer;     {human fights left}
       gold       : LongInt;     {gold in hand}
       bank       : LongInt;     {gold in bank}
       def        : Integer;     {total defense points }
       strength   : Integer;     {total strength}
       charm      : Integer;     {good looking meter}
       seen_dragon: Integer;     {seen dragon?  5 if yes else 0}
       seen_violet: Integer;     {seen violet?  5 if yes else 0}
       level      : Integer;     {level of player}
       time       : Word;        {day # that player last played on}
       arm        : STRING[20];  {armour name}
       arm_num    : Integer;     {armour number}
       dead       : ShortInt;    {player dead?  5 if yes else 0}
       inn        : ShortInt;    {player sleeping at inn?  5 if yes else 0}
       gem        : Integer;     {# of gems on hand}
       exp        : LongInt;     {experience}
       sex        : ShortInt;    {gender, 5 if female else 0}
       seen_bard  : ShortInt;    {seen bard?  5 if yes else 0}
       last_alive_time : Integer;{day # player was last reincarnated on}
       Lays       : Integer;     {players lays stat}
       Why        : Integer;     {not used yet}
       on_now     : Boolean;     {is player on?}
       m_time     : Integer;     {day on_now stat was last used}
       time_on    : STRING[5];   {time player logged on in Hour:Minutes format}
       class      : ShortInt;    {class, should be 1, 2 or 3}
       extra      : Integer;     {*NEW*  If 1, player has a horse}
       love       : STRING[25];  {not used - may be used for inter-player marrages later}
       married    : Integer;     {who player is married to, should be -1 if not married}
       kids       : Integer;     {# of kids}
       king       : Integer;     {# of times player has won game}
       skillw     : ShortInt;    {number of Death Knight skill points}
       skillm     : ShortInt;    {number of Mystical Skills points}
       skillt     : ShortInt;    {number of Thieving Skills points}
       levelw     : ShortInt;    {number of Death Knight skill uses left today}
       levelm     : ShortInt;    {number of Mystical skill uses left today}
       levelt     : ShortInt;    {number of Thieving skill uses left today}
       inn_random : Boolean;     {not used yet}
       married_to : Integer;     {same as Married, I think - don't know why it's here}
       v1         : LongInt;     {completely undocumented in lord structs}
       v2         : Integer;     {# of player kills}
       v3         : Integer;     {if 5, 'wierd' event in forest will happen}
       v4         : Boolean;     {has player done 'special' for that day?}
       v5         : ShortInt;    {has player flirted with another player that day?  if so, 5}
       new_stat1  : ShortInt;    {these 3 are unused right now}
       new_stat2  : ShortInt;    {Warning: Joseph's NPCLORD screws with all three}
       new_stat3  : ShortInt;    {see above}
     END;
    {PLord = ^TLord;{}

TYPE

     TLord = RECORD
       ProgramName : STRING[60];
       LordHandle  : STRING[50];
       DoorDir     : STRING;{}
       LordFileRead: Boolean;
       FairyInHand : Boolean;
       Registered  : Boolean;
       CleanMode   : Boolean;
       RIPOnLords  : Boolean;
     END;


CONST     LordLine = '-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-';
          LordIGM : BOOLEAN = False;{Tells Angel we are in LordIGM mode using info.x dropfile}
          IgmProgName  : STRING = 'Angel IGM Module';
          IgmProgVer   : STRING = '0.1';

          LordPlayerFN = 'PLAYER.DAT';{Private later?}

VAR       LordInfoXFileName : string[79]; {path to Lord Game for commandline use}
          IGMNodeNum  : byte; {for node handling in IGM mode}
          TLordRec    : Lord_Info; {prefaces with T since it is TYPE}
          {pL : PLord;{for if I go with real pointers ^}
          pL          : TLord; {pointer to Lord Typed file - not an actual ^ }

          PlayerNum : BYTE;{Can probably go private later}
          InfoXDir  : STRING[80];{same as LordGameDir, but used differently}


{Lord writing/string handling routines}
FUNCTION  LC(S:STRING):STRING;      {translates lord colors `x and sets forground}
FUNCTION  StripLC(s:STRING):STRING; {strips lord colors for normal text without `x}

PROCEDURE LordHead(s:STRING);
PROCEDURE Lwrite(s:STRING);           {test awrite}
PROCEDURE LwriteXY(x,y:BYTE;s:STRING);{test awriteXY}
PROCEDURE Lwriteln(s:STRING);         {test awriteln}
{End writing/string handling routines}

{Lord player handling routines}
PROCEDURE BankCheck(Add:Integer);
PROCEDURE CharmCheck(Added:Integer);
PROCEDURE DefCheck(Added:Integer);
PROCEDURE ExpCheck(Added:Integer);
PROCEDURE GemCheck(Added:Integer);
PROCEDURE GoldCheck(Added:LongInt);
PROCEDURE HitMaxCheck(Added:Integer);
PROCEDURE ForestCheck(Added:Integer);
PROCEDURE HitPointsCheck(Added:Integer);
PROCEDURE HumanCheck(Added:Integer);
PROCEDURE KidCheck(Added:Integer);
PROCEDURE LaysCheck(Added:Integer);
PROCEDURE LevelCheck(Added:Integer);
PROCEDURE StrengthCheck(Added:Integer);
PROCEDURE Bard(YesNo:Boolean);
PROCEDURE Dead;
PROCEDURE Fairy(YesNo:Boolean);
PROCEDURE Flirt(YesNo:Boolean);
PROCEDURE Horse(YesNo:Boolean);
PROCEDURE Violet(YesNo:Boolean);
{End Lord player handling routines}


{Misc}
PROCEDURE ATM(BankName:STRING);{new improved might be in kdrive v7.2, but it don't work, this one does}
FUNCTION  GetAInput(s:STRING):CHAR; {Might want to add to Angel}
{End Misc}



{Other things Kdrive did}
FUNCTION  AddBack(DirName : string) : string;
PROCEDURE LordView;
PROCEDURE PauseL;      {this is the lord <more> prompt}
PROCEDURE AddLordLog(Title1:STRING;EndAdd:Boolean);{}
PROCEDURE CloseLord;   {updates / writes lord player.dat}

PROCEDURE ReadInfoX;   {inits door and reads info.x} {formerly GetIgmInfo}
PROCEDURE UpDateInfoX; {updates/re-writes info.x on exit from IGM}
{End of other things Kdrive did}


{Read write directly to 3rdparty.dat}
PROCEDURE ReadLordFile;    {read lords player.dat}
PROCEDURE WriteLordFile;   {writes lord player.dat}
PROCEDURE UpDatePlayerDat; {updates/reads/writes lord player.dat}
{End Read/write to 3rdparty.dat}



{move these to Angel or Kangel}
FUNCTION GetNumber(LongInt1:LongInt;NewX,NewY:Byte;Lo,Hi:LongInt):LongInt;{Gets number between lo/hi at xy coordinate}
FUNCTION CommaPlace(Number:LONGINT):STRING;{Convert number to string output and adds commas}
{end move to Angel or Kangel??}


IMPLEMENTATION
USES CRT, angelKD, Angel;



VAR LordFile     : FILE OF Lord_Info;

    InfoFile     : TEXT;
    ExitSaveLord : Pointer;

    GraphicPlaceHolder: STRING[2];{Temp until correct way figured out}
    FossilPlaceHolder : STRING[2];{Temp until correct way figured out}


FUNCTION GetAInput(s:STRING):CHAR; {Might want to add to Angel}
VAR  Ch : CHAR;
  PROCEDURE GetKey;
  BEGIN
    Ch:=Upcase(aReadKey);
  END;
BEGIN
  REPEAT
    GetKey;
  UNTIL POS(Ch,s) > 0;
  GetAInput:=ch;
END;

PROCEDURE ClearKeyboardBuffer; {Might want to make this public in Angel, ripped from angel code}
BEGIN
  WHILE aKeyPressed DO IF aReadKey = #0 THEN; {while aKeyPressed do aReadKey;}
END;{ClearKeyboardBuffer}

PROCEDURE PauseL;{Lord <MORE> pause}
VAR  cx,cy,wx,wy : BYTE;
BEGIN
  ClearKeyboardBuffer;
  cx:=aGetFore; cy:=AGetback;
  wx:=wherex; wy:=wherey;
  aWriteIcc('^\02  <^\0AMORE^\02>');
  aSetColor(cx, cy);
  aGotoXY(wx,wy);
  DisplayStatus(AI.StatusType);
  aReadKey;
  ClearKeyboardBuffer;
  aWrite(charstr(#32,12));
  aGotoXY(wx,wy);
END;{PauseL}

PROCEDURE AddText(s,TextFN:STRING;Kill:Boolean); {FileName / Text String}
VAR  F : TEXT;
  PROCEDURE NewTextFile;
  BEGIN
    Assign(F,TextFN);
    Rewrite(F);
    Close(F);
  END;{NewTextFile}
BEGIN
  IF Kill THEN KillFile(TextFN);
  IF NOT FileExist(TextFN) THEN NewTextFile;
  Assign(F,TextFN);
  Append(F);
  WriteLn(F,s);
  Close(F);
END;{AddText}

FUNCTION  CheckInt(Val1,Val2:Integer):Integer;
CONST Diff : Integer = 0;
BEGIN
  IF (Val1>0) THEN BEGIN
    Diff:=(32767 - Val2);
    IF (Diff>Val1) THEN Diff:=Val1;
  END ELSE IF (Val1<0) THEN BEGIN
    Diff:=(32768 + Val2);
    IF (Diff<Val1) THEN Diff:=Val1;
   END ELSE IF (Val1=0) THEN Diff:=0;
   CheckInt:=Val2+Diff;
END;{CheckInt}

FUNCTION  CheckLongInt(Val1,Val2:LongInt):LongInt;
CONST Diff : LongInt = 0;
BEGIN
  IF (Val1>0) THEN BEGIN
    Diff:=(2147483647 - Val2);
    IF (Diff>Val1) THEN Diff:=Val1;
  END ELSE IF (Val1<0) THEN BEGIN
    Diff:=(-2147483647 + Val2);
    IF (Diff<Val1) THEN Diff:=Val1;
   END ELSE IF (Val1=0) THEN Diff:=0;
   CheckLongInt:=Val2+Diff;
END;{CheckLongInt}

FUNCTION AddBack(DirName:STRING):STRING;
CONST DosDelimSet : SET OF Char = ['\', ':', #0];
BEGIN
  IF DirName[Length(DirName)] IN DosDelimSet THEN AddBack := DirName ELSE AddBack := DirName+'\';
END;{AddBack}

PROCEDURE ShowErr(S:STRING);
BEGIN
  aSetColor(15,0);
  aWriteln('ERROR: '+s);
  Snooze(2000);
  Halt;
END;{ShowErr}

FUNCTION  b2yn(Boo:Boolean):STRING;{Translate boolean expression to yes/no text}
BEGIN
  IF Boo THEN B2YN:='yes' ELSE b2YN:='no';
END;{b2yn}

PROCEDURE UpDatePlayerDat; {used when still in game and want to write back to player.dat}
BEGIN
  IF NOT pL.LordFileRead THEN ReadLordFile;{if we haven't read it, then read it}
  TLordRec.On_Now:=False;
  TLordRec.Inn:=0;
  WriteLordFile;
END;{UpDatePlayerDat}

PROCEDURE CloseLord; {mostly redundant}
BEGIN
  UpDatePlayerDat;
  pL.LordFileRead:=False;
END;

PROCEDURE UpDateInfoX; {This is were we rewrite the info.x on exit}
VAR  xa : ARRAY[1..14] OF STRING; {array of the 14 lines in info.x}
     i  : Byte;
BEGIN
  xa[1] :=Int2Str(PlayerNum);
  xa[2] :=GraphicPlaceHolder;
  xa[3] :='RIP '+UpStr(B2YN(pL.RipOnLords));
  xa[4] :='FAIRY '+UpStr(B2YN(pL.FairyInHand));{}
  xa[5] := Int2Str(time_left);
  xa[6] := pL.LordHandle;
  xa[7] := user.FirstName;
  xa[8] := user.LastName;
  xa[9] := Int2Str(bbs.Comport);
  xa[10]:= Int2Str(bbs.BaudRate);
  xa[11]:= Int2Str(bbs.LockedBaud);
  xa[12]:=FossilPlaceHolder;
  IF pL.Registered THEN xa[13]:='REGISTERED' ELSE xa[13]:='UNREGISTERED';
  IF pL.CleanMode THEN xa[14]:='CLEAN MODE ON' ELSE xa[14]:='CLEAN MODE OFF';
  KillFile(LordInfoXFileName);
  FOR i := 1 TO 14 DO AddText(xa[i],LordInfoXFileName,False);{writes the new update infoX}
END;

FUNCTION GetFilePath(InString:STRING):STRING;
VAR  Loop : BYTE;
BEGIN
  IF InString[Length(InString)]='\' THEN
  BEGIN
    GetFilePath:=InString;
    Exit;
  END;
  Loop := LENGTH(InString);
  REPEAT Dec(Loop) UNTIL ((Loop=0) OR (InString[Loop]='\'));
  IF Loop<>0 THEN Delete(InString,Loop+1,Length(InString)-Loop) ELSE InString:='';
  GetFilePath:=InString;
END;

PROCEDURE ReadInfoX;  {This is where we read info.x and fill the Angel variables}
VAR  xa : ARRAY[1..14] OF STRING;
     i  :Integer;
BEGIN
  InfoXDir := AddBack(bbs.DropFilePath);{Lord Directory ie. c:\lord\}
  bbs.doorpath:=InfoXDir;{if this is changed to actual igm dir, lord don't reload}
  pL.DoorDir:=DoorDir;
  LordInfoXFileName:=AddBack(InfoXDir)+'INFO.'+ Int2Str(bbs.Node);{}
  FOR i := 1 TO 14 DO xa[i]:='';
  i:=0;
  IF NOT FileExist(LordInfoXFileName) THEN ShowErr('Error1 opening '+LordInfoXFileName+' File, screaching to program halt!');
  Assign(InfoFile,LordInfoXFileName);
  Reset(InfoFile);
  REPEAT
    INC(i);
    {$I-}
     ReadLn(InfoFile,xa[i]);
    {$I+}
  UNTIL (EOF(InfoFile)) OR (i>=14);
  Close(InfoFile);
  IF IOResult <> 0 THEN ShowErr('Error2 opening '+LordInfoXFileName+' File, screaching to program halt!');
  { 1} PlayerNum:=Str2Int(xa[1]);
  { 2} GraphicPlaceHolder:=xa[2];
  { 3} IF (Pos('YES',UpStr(xa[3]))<>0) THEN pL.RipOnLords:=True ELSE pL.RipOnLords:=False;
  { 4} IF (Pos('YES',UpStr(xa[4]))<>0) THEN pL.FairyInHand:=True ELSE pL.FairyInHand:=False;

  { 5} bbs.timeleft:=Str2Int(xa[5]);     {pass to angel}
  { 5} bbs.actualtime:=Str2Int(xa[5]);   {pass to angel} {pass to angel - needed?}

  { 6} pL.LordHandle:=xa[6];
  { 7} user.FirstName:=xa[7];            {pass to angel}
  { 8} user.LastName:=xa[8];             {pass to angel}
  { 9} bbs.Comport:=Str2Int(xa[9]);      {pass to angel}
        if bbs.Comport = 0 then AI.Local := true; {JR}
  {10} bbs.BaudRate:=Str2Int(xa[10]);    {pass to angel}
  {11} bbs.LockedBaud:=Str2Int(xa[11]);  {pass to angel}

  {12} FossilPlaceHolder:=xa[12];        {need to pass to angel? don't think so}

  bbs.node:=IGMnodeNum;                  {pass to angel}

  user.alias:=pL.LordHandle;           {pass lord name to angel}

  user.uname:=pL.LordHandle;           {pass lord name to angel}

  {13} IF (UpStr(xa[13])='REGISTERED') THEN pL.Registered:=True ELSE pL.Registered:=False;
  {14} IF (UpStr(xa[14])='CLEAN MODE OFF') THEN pL.CleanMode:=False ELSE pL.CleanMode:=True;{}

END;

PROCEDURE ReadLordFile;{Reads lord Player.dat}
BEGIN
  Assign(LordFile,InfoXDir+LordPlayerFN);
  Reset(LordFile);
  Seek(LordFile,PlayerNum);
  Read(LordFile,TLordRec);
  Close(LordFile);
  pL.LordFileRead:=True; {Lets us know we read it, so we need write it back at some point{}
END;{ReadLordFile}

PROCEDURE WriteLordFile;{Writes lord Player.dat}
BEGIN
  Assign(LordFile,InfoXDir+LordPlayerFN);
  Reset(LordFile);
  Seek(LordFile,PlayerNum);
  Write(LordFile,TLordRec);
  Close(LordFile);
END;{WriteLordFile}

FUNCTION  StripLC(s:STRING):STRING;{Strips Lord color codes from string}
BEGIN
  WHILE POS('`',s)>0 DO Delete(s,Pos('`',s),2);
  StripLC:=s;
END;{StripLC}

FUNCTION  LC(S:STRING):STRING;{translates lord color codes}
VAR  a    : Byte;
     StrX : STRING;
BEGIN
  StrX:='';
  FOR a:=1 TO Length(s) DO BEGIN
    IF (S[a]='`') THEN
    BEGIN
      IF (a>=Length(s)) THEN Exit;
      CASE UpCase(S[A+1]) OF
        '1' : BEGIN aSetFore(1);A:=a+1;END;
        '2' : BEGIN aSetFore(2);A:=a+1;END;
        '3' : BEGIN aSetFore(3);A:=a+1;END;
        '4' : BEGIN aSetFore(4);A:=a+1;END;
        '5' : BEGIN aSetFore(5);A:=a+1;END;
        '6' : BEGIN aSetFore(6);A:=a+1;END;
        '7' : BEGIN aSetFore(7);A:=a+1;END;
        '8' : BEGIN aSetFore(8);A:=a+1;END;
        '9' : BEGIN aSetFore(9);A:=a+1;END;
        '0' : BEGIN aSetFore(10);A:=a+1;END;
        '!' : BEGIN aSetFore(11);A:=a+1;END;
        '@' : BEGIN aSetFore(12);A:=a+1;END;
        '#' : BEGIN aSetFore(13);A:=a+1;END;
        '$' : BEGIN aSetFore(14);A:=a+1;END;
        '%' : BEGIN aSetFore(15);A:=a+1;END;
      END;
    END ELSE aWrite(s[a]);
  END;
  LC:=StrX;
END;{LC}

PROCEDURE Lwrite(s:STRING);{writes a lord color codes string with color translation}
BEGIN
  aWrite(LC(s));
END;{Lwrite}

PROCEDURE Lwriteln(s:STRING);{writes a lord color codes string with color translation}
BEGIN
  aWriteln(LC(s));
END;{Lwriteln}

PROCEDURE LwriteXY(x,y:BYTE;s:STRING);{writes a lord color codes string at XY with color translation}
BEGIN
  aGotoXY(x,y);
  aWrite(LC(s));
END;{LwriteXY}

PROCEDURE DoneLord;{Exit routines to make sure we rewrite InfoX and Player.dat}
BEGIN
{  Writeln('Welcome to the exitproc/DoneWithLord!');
  Readkey;{}
  UpdateInfoX;
  IF pL.LordFileRead THEN WriteLordFile;{If we read it way back when, lets write it back}
  aClr;
{  IF pL<> NIL THEN Dispose(pL);{}
END;{DoneLord}

PROCEDURE ExitLord;FAR;
BEGIN
  ExitProc:=ExitSaveLord;
  DoneLord;
  ClrScr;
{  Writeln('Final exit stage of IGM'); ReadKey;{}
END;{ExitLord}

PROCEDURE BankCheck(Add:Integer);
BEGIN
  TLordRec.Bank:=CheckLongInt(Add,TLordRec.Bank);
END;{BankCheck}

PROCEDURE CharmCheck(Added:Integer);
BEGIN
  TLordRec.Charm:=CheckInt(added,TLordRec.Charm);
END;{CharmCheck}

PROCEDURE DefCheck(Added:Integer);
BEGIN
  TLordRec.Def:=CheckInt(added,TLordRec.Def);
END;{DefenseCheck}

PROCEDURE ExpCheck(Added:Integer);
BEGIN
  TLordRec.Exp:=CheckInt(Added,TLordRec.Exp);
END;{ExpCheck}

PROCEDURE GemCheck(Added:Integer);
BEGIN
  TLordRec.Gem:=CheckInt(added,TLordRec.Gem);
END;{GemCheck}

PROCEDURE GoldCheck(Added:LongInt);
BEGIN
  TLordRec.Gold:=CheckLongInt(Added,TLordRec.Gold);
END;{GoldCheck}

PROCEDURE HitMaxCheck(Added:Integer);
BEGIN
  TLordRec.Hit_Max:=CheckInt(added,TLordRec.Hit_Max);
END;{HitMaxCheck}

PROCEDURE ForestCheck(Added:Integer);
BEGIN
  TLordRec.Fights_Left:=CheckInt(added,TLordRec.Fights_Left);
END;{ForestCheck}

PROCEDURE HitPointsCheck(Added:Integer);
BEGIN
  TLordRec.Hit_Points:=CheckInt(added,TLordRec.Hit_Points);
END;{HitPointCheck}

PROCEDURE HumanCheck(Added:Integer);
BEGIN
  TLordRec.Human_Left:=CheckInt(added,TLordRec.Human_Left);
END;{HumanCheck}

PROCEDURE KidCheck(Added:Integer);
BEGIN
  TLordRec.Kids:=CheckInt(added,TLordRec.Kids);
END;{KidCheck}

PROCEDURE LaysCheck(Added:Integer);
BEGIN
  TLordRec.Lays:=CheckInt(Added,TLordRec.Lays);
END;{LaysCheck}

PROCEDURE LevelCheck(Added:Integer);
BEGIN
  IF TlordRec.Level+Added <= 1 THEN Exit;
  IF TlordRec.Level+Added >=12 THEN Exit;
  TlordRec.Level:=TlordRec.Level+Added;
END;

PROCEDURE StrengthCheck(Added:Integer);
BEGIN
  TLordRec.Strength:=CheckInt(added,TLordRec.Strength);
END;{StrenthCheck}

PROCEDURE Dead; {Kills player}
BEGIN
  TLordRec.Dead:=5;
  TLordRec.Hit_Points:=0;
  TLordRec.Gold:=0;
END;{Dead}

PROCEDURE Fairy(YesNo:Boolean);{Give or take fairy}
BEGIN
  pL.FairyInHand:=YesNo;
END;{Fairy}

PROCEDURE Horse(YesNo:Boolean);{Give or take horse}
BEGIN
  IF YesNo THEN TLordRec.Extra:=1 ELSE TLordRec.Extra:=0;
END;{Horse}

PROCEDURE Bard(YesNo:Boolean);{Seen bard or not}
BEGIN
  IF YesNo THEN TLordRec.Seen_Bard:=5 ELSE TLordRec.Seen_Bard:=0;
END;{Bard}

PROCEDURE Flirt(YesNo:Boolean);{flirt or not}
BEGIN
  IF YesNo THEN TLordRec.V5:=0 ELSE TLordRec.V5:=5;
END;{Flirt}

PROCEDURE Violet(YesNo:Boolean);{seen violet or not}
BEGIN
  IF YesNo THEN TLordRec.Seen_Violet:=5 ELSE TLordRec.Seen_Violet:=0;
END;{Violet}

PROCEDURE LordView;{same as lords view stats}
VAR SkillUses:Byte;
  FUNCTION  SkillLevel(Skills:Byte):STRING;
  BEGIN
    SkillLevel:='NONE';
    IF (Skills=0) THEN Exit;
    SkillLevel:=Int2Str(Skills);
  END;
BEGIN
  LordHead('`%  '+pL.LordHandle+#39+'`2s Stats...');
  LWriteLn('`2  Experience   : `0'+Int2Str(TLordRec.Exp));
  LWrite('`2  Level        : `0'+Int2Str(TLordRec.Level));            aGotoXY(36,WhereY);
  Lwriteln('`2Hit Points         :(`0'+Int2Str(TLordRec.Hit_Points)+' `2of `0'+Int2Str(TLordRec.Hit_Max)+'`2)');
  LWrite('`2  Forest Fights: `0'+Int2Str(TLordRec.Fights_Left));      aGotoXY(36,WhereY);
  Lwriteln('`2Player Fights Left : `0'+Int2Str(TLordRec.Human_Left));
  LWrite('`2  Gold In Hand : `0'+Int2Str(TLordRec.Gold));             aGotoXY(36,WhereY);
  Lwriteln('`2Gold In Bank       : `0'+Int2Str(TLordRec.Bank));
  LWrite('`2  Weapon       : `0'+TLordRec.Weapon);                    aGotoXY(36,WhereY);
  Lwriteln('`2Attack Strength    : `0'+Int2Str(TLordRec.Strength));
  LWrite('`2  Armour       : `0'+TLordRec.Arm);                       aGotoXY(36,WhereY);
  Lwriteln('`2Defensive Strength : `0'+Int2Str(TLordRec.Def));
  LWrite('`2  Charm        : `0'+Int2Str(TLordRec.Charm));            aGotoXY(36,WhereY);
  Lwriteln('`2Gems               : `0'+Int2Str(TLordRec.Gem));
  aWriteLn('');

  Lwriteln('`2  You have `0'+Int2Str(TLordRec.Kids)+' `2child');

  aWriteLn('');
  LWrite('`2  Death Knight Skills: `0'+SkillLevel(TLordRec.SkillW));  aGotoXY(36,WhereY);
  Lwriteln('`2Uses Today         : (`0'+Int2Str(TLordRec.LevelW)+'`2)');
  LWrite('`2  The Mystical Skills: `0'+SkillLevel(TLordRec.Skillm));  aGotoXY(36,WhereY);
  Lwriteln('`2Uses Today         : (`0'+Int2Str(TLordRec.Levelm)+'`2)');
  LWrite('`2  The Thieving Skills: `0'+SkillLevel(TLordRec.Skillt));  aGotoXY(36,WhereY);
  Lwriteln('`2Uses Today         : (`0'+Int2Str(TLordRec.Levelt)+'`2)');
  aWriteLn('');
  LWrite('`0  You are currently interested in `%');
  CASE TLordRec.Class OF
    1 : LWriteLn('Death Knight `0Skills.');
    2 : LWriteLn('The Mystical `0Skills.');
    3 : LWriteLn('The Thieving `0Skills.');
  END;
  aWriteLn('');
  PauseL;
 END;{LordView}

PROCEDURE LordHead(s:STRING);{Lord type header string }
BEGIN                        {  Headertext            }
  aClr;                      {-=-=-=-=-=-=- lordline  }
  aWriteLn('');
  aWriteln('');
  aWriteln('');
  LWriteLn(s);
  LWriteLn('`0'+LordLine);
END;{LordHead}

FUNCTION  IsNumber(s:STRING):BOOLEAN;
VAR  i : BYTE;
     Number : BOOLEAN;
BEGIN
  IsNumber:=True;
  FOR i:=1 TO Length(s) DO
  BEGIN
    IF s[i] IN ['0'..'9'] THEN Number:=True ELSE Number:=False;
    IF Number=False THEN
    BEGIN
      IsNumber:=False;
      Exit;
    END;
  END;
END;

FUNCTION CommaPlace(Number:LONGINT):STRING;{Convert number to string output and adds commas}
VAR  NumStr : STRING[15];
     Len    : BYTE;
     i      : BYTE;
BEGIN
  Str(Number,NumStr);
  Len:=Length(NumStr);
  i:=Len+1;
  WHILE (i>4) AND (i <=Len+1) DO
  BEGIN
    Dec(i,3);
    Insert(',',NumStr,i);
  END;
  CommaPlace:=NumStr;
END;{CommaPlace}

FUNCTION  GetNumber(LongInt1:LongInt;NewX,NewY:Byte;Lo,Hi:LongInt):LongInt;
VAR Code:Integer;
    Choice:LongInt;
    TempStr:STRING;
    StoreX,StoreY:Byte;
BEGIN
  TempStr:=Int2Str(LongInt1);
  GetNumber := LongInt1;
  aGotoxy(NewX,NewY);
  Prompt(TempStr,Length(Int2Str(Hi)),True);
  {$R-}
  Val(TempStr,Choice,Code);
  {$R+}
  IF (TempStr='') OR (Code<>0) THEN Exit;
  IF (Choice>=Lo) AND (Choice<=Hi) THEN GetNumber := Choice;
END;

PROCEDURE ATM(BankName:STRING); {Much redundant code in here, but for now it works!}
VAR  Ch:CHAR;                   {Can streamline it later, if ever....}
     Update:Boolean;

  FUNCTION  LowOutFunds(depo:LongInt):Boolean;
  BEGIN
    IF depo>TLordRec.Bank THEN LowOutFunds:=True ELSE
    BEGIN
      LowOutFunds:=False;
      Exit;
    END;
    NewLnn(2);
    Lwriteln('   `0Insufficient funds!  Try again!');
    NewLn;
    PauseL;
    Update:=True;
    ClearRegion(1,WhereY-6,24);{}
  END;

  FUNCTION  LowInFunds(depo:LongInt):Boolean;
  BEGIN
    IF depo>TLordRec.Gold THEN LowInFunds:=True ELSE
    BEGIN
      LowInFunds:=False;
      Exit;
    END;
    NewLnn(2);
    Lwriteln('   `0Insufficient funds!  Try again!');
    NewLn;
    PauseL;
    Update:=True;
    ClearRegion(1,WhereY-6,24);{}
  END;

  FUNCTION  FundsInOk(depo:LongInt):Boolean;
  BEGIN
    IF depo<=TLordRec.Gold THEN FundsInOk:=True ELSE
    BEGIN
      FundsInOk:=False;
      Exit;
    END;
    NewLnn(2);
    Lwriteln('   `0Transaction accepted!  Thank you and have a nice day!');
    NewLn;
    PauseL;
  END;

  FUNCTION  FundsOutOk(depo:LongInt):Boolean;
  BEGIN
    IF depo<=TLordRec.Bank THEN FundsOutOk:=True ELSE
    BEGIN
      FundsOutOk:=False;
      Exit;
    END;
    NewLnn(2);
    Lwriteln('   `0Transaction accepted!  Thank you and have a nice day!');
    NewLn;
    PauseL;
  END;

  PROCEDURE BankDeposit;
  VAR  Depo:LongInt;
       x,y:BYTE;
  BEGIN
    x:=WhereX;
    y:=WhereY;
    NewLnn(2);
    LWrite('   `2How much gold would you like to deposit?');
    Depo:=GetNumber(0,WhereX+1,WhereY,0,2147483647);
    Awriteln('');
    Lwrite('   `2Are you sure you want to deposit `0'+CommaPlace(Depo)+' `2gold? `%Y/N');
    CASE GetAInput('YN') OF
      'Y' : BEGIN
              IF LowInFunds(depo) THEN Exit;
              IF FundsInOk(depo) THEN
              BEGIN
                BankCheck(Depo);
                GoldCheck(-Depo);
              END;
            END;
      'N' : ;
    END;
    Update:=True;
    ClearRegion(1,y+1,24);
    AgotoXY(x,y);
  END;

  PROCEDURE BankWithDraw;
  VAR  Depo:LongInt;
       x,y:BYTE;
  BEGIN
    x:=WhereX;
    y:=WhereY;
    NewLnn(2);
    LWrite('   `2How much gold would you like to withdraw?');
    Depo:=GetNumber(0,WhereX+1,WhereY,0,2147483647);
    Awriteln('');
    Lwrite('   `2Are you sure you want to withdraw `0'+CommaPlace(Depo)+' `2gold? `%Y/N');
    CASE GetAInput('YN') OF
      'Y' : BEGIN
              IF LowOutFunds(depo) THEN Exit;
              IF FundsOutOk(depo) THEN
              BEGIN
                BankCheck(-Depo);
                GoldCheck(+Depo);
              END;
            END;
      'N' : ;
    END;
    Update:=True;
    ClearRegion(1,y+1,24);
    AgotoXY(x,y);
  END;
BEGIN
  LordHead('  '+BankName);
  aWriteln('');
  Lwriteln('   `2(`5D`2)eposit Gold');
  Lwriteln('   `2(`5W`2)ithdraw Gold');
  Lwriteln('   `2(`5R`2)eturn');
  aWriteln('');
  Lwriteln('   `2Gold In Hand:`0 '+CommaPlace(TlordRec.Gold));
  Lwriteln('   `2Gold In Bank:`0 '+CommaPlace(TlordRec.Bank));
  aWriteln('');
  Lwrite('   `2Which will it be? ['+int2Str(Time_Left)+']:');{}
  Update:=False;

  REPEAT
    IF Update THEN
    BEGIN
      LwriteXY(17,11,'`0 '+CommaPlace(TlordRec.Gold));aClrEol;
      LwriteXY(17,12,'`0 '+CommaPlace(TlordRec.Bank));aClrEol;
      NewLnn(2);
      Lwrite('   `2What now? ['+int2Str(Time_Left)+']:');aClrEol;
    END;
    Update:=False;
    Ch:=GetAInput('DWR');
    CASE Ch OF
      'D' : BankDeposit;
      'W' : BankWithDraw;
      'R' : Exit;
    END;
  UNTIL Ch='R';
END;

PROCEDURE AddLordLog(Title1:STRING;EndAdd:Boolean);
VAR Dat3Fn:STRING[80];
BEGIN
  Dat3Fn:=AddBack(InfoXDir)+'LOGNOW.TXT';
  AddText('  '+Title1,Dat3Fn,False);
  IF EndAdd THEN AddText('`.                                `2-`0=`2-`0=`2-`0=`2-',Dat3Fn,False);
END;
BEGIN
{  New(pL);{}
  ExitSaveLord := ExitProc;
  ExitProc     := @ExitLord;
END.