/*
 * $Id$
 */
package com.mycompany.myproject.tests;

import java.io.File;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.xins.common.servlet.container.HTTPServletHandler;

/**
 * Testcase that includes all the tests for the myproject API.
 *
 * @version $Revision$ $Date$
 */
public class APITests extends TestCase {

    /**
     * The Servlet server running the API. The value is <code>null</code> if the server is not started.
     */
    private static HTTPServletHandler API_SERVER;

    /**
     * Flag that indicates that the API has been started.
     */
    private static boolean API_STARTED = false;

    /**
     * Constructs a new <code>APITests</code> test suite with
     * the specified name. The name will be passed to the superconstructor.
     *
     * @param name
     *      the name for this test suite.
     */
    public APITests(String name) {
        super(name);
    }

    /**
     * Returns a test suite with all test cases defined by this class.
     *
     * @return
     *     the test suite, never <code>null</code>.
     */
    public static Test suite() {

        TestSuite suite = new TestSuite();

        if ("true".equals(System.getProperty("test.start.server"))) {
            suite.addTestSuite(StartServer.class);
        }
        // Add all tests
        suite.addTestSuite(MyFunctionTests.class);
        if ("true".equals(System.getProperty("test.start.server"))) {
            suite.addTestSuite(StopServer.class);
        }

        return suite;
    }

    /**
     * Starts the web server.
     */
    public static class StartServer extends TestCase {

        /**
         * Constructs a new <code>StartServer</code> test suite with
         * the specified name. The name will be passed to the superconstructor.
         *
         * @param name
         *     the name for this test suite.
         */
        public StartServer(String name) {
            super(name);
        }

        /**
         * Returns a test suite with all test cases defined by this class.
         *
         * @return
         *     the test suite, never <code>null</code>.
         */
        public static Test suite() {
            return new TestSuite(StartServer.class);
        }

        /**
         * Unit test that is only used to start the Servlet API if the 
         * test.start.server build properties is set to true.
         *
         * @throws Exception
         *    if the internal Servlet container cannot be started for any reasons.
         */
        public void testStartServer() throws Exception {

            String warLocation = "build/webapps/myproject/myproject.war".replace('/', File.separatorChar);
            File warFile = new File(System.getProperty("user.dir"), warLocation);
            int port = 8080;
            if (System.getProperty("servlet.port") != null && !System.getProperty("servlet.port").equals("")) {
                port = Integer.parseInt(System.getProperty("servlet.port"));
            }

            // Start the web server
            API_SERVER = new HTTPServletHandler(warFile, port, true);
            API_STARTED = true;
        }
    }

    /**
     * Stops the web server.
     */
    public static class StopServer extends TestCase {

        /**
         * Constructs a new <code>StopServer</code> test suite with
         * the specified name. The name will be passed to the superconstructor.
         *
         * @param name
         *     the name for this test suite.
         */
        public StopServer(String name) {
            super(name);
        }

        /**
         * Returns a test suite with all test cases defined by this class.
         *
         * @return
         *     the test suite, never <code>null</code>.
         */
        public static Test suite() {
            return new TestSuite(StopServer.class);
        }

        /**
         * Unit test that is only used to stop the Servlet API if the servlet
         * is started.
         *
         * @throws Exception
         *    if the internal Servlet container cannot be stopped for any reasons.
         */
        public void testStopServer() throws Exception {

            if (API_STARTED) {
                API_SERVER.close();
            }
        }
    }
}
