DEFINT A-Z
'$INCLUDE: 'SUPP.BI'
'$INCLUDE: 'SCOMMON.BI'

CONST LogDefaultName$ = "CHAT.TXT"
CONST LogArrow$ = ">"
DIM SHARED BHelpBuff$(40)

ErrorOccur:
  Erred% = -1
  RESUME NEXT

ChatHelpScreen:
DATA "SuperChatter Help.  Hit Spacebar to exit Help, or tap Enter to scroll."
DATA ""
DATA "ACTION                UNIVERSAL     ANSI key        DOORWAY mode key"
DATA "            "
DATA "Redraw screen         ctrl-L        ctrl-L          Alt-R"
DATA "Clear window          ctrl-K        ctrl-K          Alt-C / ctrl-Home"
DATA "Backspace             ctrl-H        Backspace       Backspace"
DATA "Up                    ctrl-E        Up              Up"
DATA "Down                  ctrl-X        Down            Down"
DATA "Left                  ctrl-S        Left            Left"
DATA "Right                 ctrl-D        Right           Right"
DATA "Insert mode           ctrl-V        ctrl-V          Ins"
DATA "Delete char           ctrl-G        Del             Del"
DATA "Home                  ctrl-O        Home            Home"
DATA "End                   ctrl-P        End             End"
DATA "Page up               ctrl-R        ctrl-R          PgUp"
DATA "Page down             ctrl-C        ctrl-C          PgDn"
DATA "Word left             ctrl-A        ctrl-A          ctrl-Left"
DATA "Word right            ctrl-F        ctrl-F          ctrl-Right"
DATA "Scroll text up        ctrl-Z        ctrl-Z          ctrl-Z"
DATA "Scroll text down      ctrl-W        ctrl-W          ctrl-W"
DATA "Delete line           ctrl-Y        ctrl-Y          ctrl-Y"
DATA "Undelete line         ctrl-U        ctrl-U          ctrl-U"
DATA "Delete word           ctrl-T        ctrl-T          ctrl-T"
DATA "Top of text                                         ctrl-PgUp"
DATA "End of text                                         ctrl-PgDn"
DATA "Clear to EOL                                        ctrl-End / F6"
DATA "This help             ctrl-N        ctrl-N          F1"
DATA "Exit help             Space         Space           F1"
DATA ""
DATA ""
DATA "Commands              Command to type on a blank line"
DATA ""
DATA "Exit SuperChatter:    TERMINATE"
DATA "Override Exit:        WAIT!"
DATA ""
DATA ""
DATA "Hit spacebar to exit Help."
DATA "@"

SUB BClose
  ON ERROR GOTO ErrorOccur
  FOR Each% = 1 TO NumWin%
    CLOSE Each%
    KILL BFileName$(Each%)
  NEXT Each%
  ON ERROR GOTO 0
END SUB

SUB BInitialize
  ON ERROR GOTO ErrorOccur
  KILL "SCBUFF1.$*"
  KILL "SCBUFF2.$*"
  KILL "SCBUFF3.$*"
  KILL "SCBUFF4.$*"
  FOR Each% = 1 TO NumWin%
    FOR Lines% = 0 TO BMaxMemory% - 1
      BMemory(Each%, Lines%) = SPACE$(ChatWid%)
    NEXT Lines%
    FOR Lines% = 0 TO BuffLines% - 1
      BIndex%(Each%, Lines%) = Lines%
      BFlag%(Each%, Lines%) = 1
    NEXT Lines%
    BCurrLine$(Each%) = SPACE$(ChatWid%)
    BMemoryTop%(Each%) = 0
    BBottom%(Each%) = 1
    BuffFile$ = "SCBUFF" + HEX$(Each%) + ".$$$"
    TEST$ = BuffFile$
    Num% = 0
    DO
      Erred% = 0
      CLOSE Each%
      OPEN TEST$ FOR INPUT AS Each%
      IF Erred% THEN EXIT DO
      Num$ = RIGHT$(HEX$(Num%), 2)
      TEST$ = LEFT$(BuffFile$, LEN(BuffFile$) - LEN(Num$)) + Num$
      Num% = Num% + 1
    LOOP UNTIL Num% = &H111
    IF Erred% THEN
      Erred% = 0
      OPEN TEST$ FOR BINARY AS Each% LEN = 4096
      IF Erred% THEN Num% = &H1101
    ELSE
      Num% = &H1101
    END IF
    IF Num% = &H1101 THEN
      IF NotFirst% = 0 THEN
        PLAY "mbl6o3co4d"
        PRINT "ERROR opening temporary files for SuperChatter!"
        PRINT "There will be erratic operation in SuperChatter."
        SLEEP 3
        NotFirst% = -1
      END IF
      BFileName$(Each%) = ""
    ELSE
      BFileName$(Each%) = TEST$
    END IF
  NEXT Each%
  RESTORE ChatHelpScreen
  FOR HelpBuff% = 0 TO UBOUND(BHelpBuff$, 1)
    READ TEST$
    IF TEST$ = "@" THEN EXIT FOR
    BHelpBuff$(HelpBuff%) = TEST$ + SPACE$(80 - LEN(TEST$))
  NEXT HelpBuff%
  BHelpBuffLen% = HelpBuff%
  ON ERROR GOTO 0
END SUB

FUNCTION BLineRead$ (Cwin%, LineNum%)
  IF Locked%(Cwin%) = -1 THEN
    BLineRead$ = BHelpBuff$(LineNum%)
    EXIT FUNCTION
  END IF
  IF LineNum% >= BuffLines% OR LineNum% < 0 THEN BLineRead$ = SPACE$(ChatWid%): EXIT FUNCTION
  Top% = BMemoryTop%(Cwin%)
  IF LineNum% < Top% THEN                                    'Scrolling up
    Top% = LineNum% - BPageLen% + 1
    BPage Cwin%, Top%, 3       'Updates the disk buffer and cache
  ELSEIF LineNum% >= Top% + BMaxMemory% OR Top% < 0 THEN     'Scrolling down
    Top% = LineNum% - BMaxMemory% + BPageLen% - 1
    BPage Cwin%, Top%, 3       'Updates the disk buffer and cache
  END IF
  'Reads line from buffer cache
  BLineRead$ = BMemory(Cwin%, LineNum% - BMemoryTop%(Cwin%))
END FUNCTION

SUB BLineWrite (Cwin%, LineNum%, BLineData$)
  IF Locked%(Cwin%) THEN EXIT SUB
  ON ERROR GOTO ErrorOccur
  Top% = BMemoryTop%(Cwin%)
  Temp$ = BLineData$ + SPACE$(ChatWid% - LEN(BLineData$))
  IF LineNum% < Top% OR LineNum% >= Top% + BMaxMemory% THEN
    IF LineNum% >= 0 AND LineNum% < BuffLines% THEN
      Rec% = BIndex%(Cwin%, LineNum%)
      IF Rec% < BuffLines% THEN
        PUT Cwin%, 1 + Rec% * ChatWid%, Temp$
        BFlag%(Cwin%, LineNum%) = 0
      ELSE
        BFlag%(Cwin%, LineNum%) = 1
      END IF
    END IF
  ELSE
    IF LEFT$(BMemory(Cwin%, LineNum% - Top%), ChatWid%) <> Temp$ THEN BFlag%(Cwin%, LineNum%) = 2
    BMemory(Cwin%, LineNum% - Top%) = Temp$
  END IF
  ON ERROR GOTO 0
END SUB

SUB BPage (Cwin%, TopLine%, AccessFlag%)     'Cache operating subroutine
  'AccessFlag%: 1 to flush cache to disk buffer
  '             2 to read full disk buffer to cache
  '             3 to flush old data from cache and read new data into cache

  Top% = BMemoryTop%(Cwin%)
  NewTop% = TopLine%
  IF NewTop% < 0 THEN
    NewTop% = 0
  ELSEIF NewTop% > BuffLines% - BMaxMemory% THEN
    NewTop% = BuffLines% - BMaxMemory%
  END IF
  IF AccessFlag% = 3 THEN
    BStep% = ABS(NewTop% - Top%)
    IF BStep% > BMaxMemory% THEN BStep% = BMaxMemory%
  ELSE
    BStep% = 100
  END IF

  Erred% = 0
  ON ERROR GOTO ErrorOccur

  IF NewTop% < Top% OR AccessFlag% <> 3 THEN         'Move up in buffer
    IF AccessFlag% AND 1 THEN
      FOR BLWrite% = BMaxMemory% - BStep% TO BMaxMemory% - 1
        Rec% = BIndex%(Cwin%, Top% + BLWrite%)
        IF Rec% < BuffLines% THEN
          IF BFlag%(Cwin%, Top% + BLWrite%) THEN
            Temp$ = LEFT$(BMemory(Cwin%, BLWrite%), ChatWid%)
            PUT Cwin%, 1 + Rec% * (ChatWid% * 1&), Temp$
            BFlag%(Cwin%, Top% + BLWrite%) = 0
          END IF
        END IF
      NEXT BLWrite%
    END IF
    IF AccessFlag% = 3 THEN
      FOR BLCopy% = BMaxMemory% - BStep% - 1 TO 0 STEP -1
        BMemory(Cwin%, BLCopy% + BStep%) = BMemory(Cwin%, BLCopy%)
      NEXT BLCopy%
    END IF
    IF AccessFlag% AND 2 THEN
      FOR BLRead% = 0 TO BStep% - 1
        Rec% = BIndex%(Cwin%, NewTop% + BLRead%)
        IF Rec% < BuffLines% AND BFlag%(Cwin%, NewTop% + BLRead%) <> 1 THEN
          Temp$ = SPACE$(ChatWid%)
          GET Cwin%, 1 + Rec% * (ChatWid% * 1&), Temp$
          BMemory(Cwin%, BLRead%) = Temp$
          BFlag%(Cwin%, NewTop% + BLRead%) = 0
        ELSE
          BMemory(Cwin%, BLRead%) = SPACE$(ChatWid%)
        END IF
      NEXT BLRead%
    END IF
  ELSE                            'Move down in buffer
    FOR BLWrite% = 0 TO BStep% - 1
      Rec% = BIndex%(Cwin%, Top% + BLWrite%)
      IF Rec% < BuffLines% THEN
        IF BFlag%(Cwin%, Top% + BLWrite%) THEN
          Temp$ = LEFT$(BMemory(Cwin%, BLWrite%), ChatWid%)
          PUT Cwin%, 1 + Rec% * (ChatWid% * 1&), Temp$
          BFlag%(Cwin%, Top% + BLWrite%) = 0
        END IF
      END IF
    NEXT BLWrite%
    FOR BLCopy% = 0 TO BMaxMemory% - BStep% - 1
      BMemory(Cwin%, BLCopy%) = BMemory(Cwin%, BLCopy% + BStep%)
    NEXT BLCopy%
    FOR BLRead% = BMaxMemory% - BStep% TO BMaxMemory% - 1
      Rec% = BIndex%(Cwin%, NewTop% + BLRead%)
      IF Rec% < BuffLines% AND BFlag%(Cwin%, NewTop% + BLRead%) <> 1 THEN
        TEST$ = SPACE$(ChatWid%)
        GET Cwin%, 1 + Rec% * (ChatWid% * 1&), TEST$
        BMemory(Cwin%, BLRead%) = TEST$
        BFlag%(Cwin%, NewTop% + BLRead%) = 0
      ELSE
        BMemory(Cwin%, BLRead%) = SPACE$(ChatWid%)
      END IF
    NEXT BLRead%
  END IF
  BMemoryTop%(Cwin%) = NewTop%
  ON ERROR GOTO 0

END SUB

SUB FCloseAll (WActive%())
  FOR TestPort% = 1 TO NumWin%
    OutSource% = WActive%(TestPort%)
    IF OutSource% >= 1 AND OutSource% <= 4 THEN FClose OutSource% - 1
  NEXT TestPort%
END SUB

SUB FInitAll (WActive%())
  FOR TestPort% = 1 TO NumWin%
    OutSource% = WActive%(TestPort%)
    IF OutSource% >= 1 AND OutSource% <= 4 THEN
      FInitialize OutSource% - 1, Errr%
      IF Errr% < 5 THEN
        COLOR 7, 0
        CLS
        PRINT
        IF Errr% < 0 THEN
          PRINT "Unable to initialize COM ports for SuperChatter. Please make sure the"
          PRINT "fossil driver is present and has a sufficent number of available ports."
        ELSE
          PRINT "Fossil driver not advanced enough to support this program!"
          PRINT "You need a fossil driver revision of at least version 5.0"
        END IF
        PRINT
        STOP
      END IF
      FInClear OutSource% - 1
      FOutClear OutSource% - 1
      IF FCarrier%(OutSource% - 1) THEN FSend OutSource% - 1, STRING$(5, CHR$(13))
    END IF
  NEXT TestPort%
END SUB

SUB LogClose (ChatLog%)
  IF ChatLog% THEN
    FOR Each% = 1 TO NumWin%
      IF LEN(RTRIM$(BCurrLine$(Each%))) THEN
        IF ChatLog% = 1 AND (BRow%(Each%) = BBottom%(Each%) - 1) THEN
          LogLine RTRIM$(BCurrLine$(Each%)), Each%
        ELSEIF ChatLog% = 2 THEN
          IF BCurrSave$(Each%) <> BCurrLine$(Each%) THEN LogLine RTRIM$(BCurrLine$(Each%)), Each%
        END IF
      END IF
    NEXT Each%
    LogLine CRLF$ + "##### " + WTProgName$ + " ended at " + TIME$ + " on " + DATE$ + " #####", 0
    LogLine "", -1
    CLOSE #10
  END IF
END SUB

SUB LogInit (ChatLog%, WName$())
  IF ChatLog% THEN
    IF Logfile$ = "" THEN Logfile$ = LogDefaultName$
    '------Unnecessarily long source of filename parser here----
    Logfile$ = Logfile$ + "\"
    Back% = 1
    MaxLeng% = 8
    DO
      New% = INSTR(Back%, Logfile$, "\")
      New2% = INSTR(Back%, Logfile$, ".")
      OldMax% = MaxLeng%
      IF New% > New2% AND New2% <> 0 THEN New% = New2%: MaxLeng% = 3 ELSE MaxLeng% = 8
      TLeng% = New% - Back%
      IF TLeng% > OldMax% THEN TLeng% = OldMax%
      Logfile$ = LEFT$(Logfile$, Back% + TLeng% - 1) + MID$(Logfile$, New%)
      Back% = Back% + TLeng% + 1
    LOOP UNTIL Back% > LEN(Logfile$)
    Logfile$ = LEFT$(Logfile$, LEN(Logfile$) - 1)
    '------Unnecessarily long source of filename parser ends----
    Erred% = 0
    ON ERROR GOTO ErrorOccur
    OPEN Logfile$ FOR BINARY ACCESS WRITE AS #10 LEN = 1024
    IF Erred% THEN
      ChatLog% = 0
      COLOR 7, 0
      CLS
      BEEP
      PRINT
      PRINT "Error in opening the SuperChatter logfile!"
      PRINT "Press a key or wait 5 seconds..."
      SLEEP 5
    ELSE
      SEEK #10, LOF(10) + 1
      LogLine "***** " + WTProgName$ + " started at " + TIME$ + " on " + DATE$ + " *****", 0
      FOR Each% = 1 TO NumWin%
        LogSymbol$(Each%) = LTRIM$(STR$(Each%)) + LogArrow$
        LogLine " is " + WName$(Each%), Each%
      NEXT Each%
      LogLine "", 0
      LogLine "", -1
    END IF
    ON ERROR GOTO 0
  END IF
END SUB

SUB LogLine (LogMsg$, LWin%) STATIC
  IF LWin% = -1 THEN
    PUT #10, , Logg$
    Logg$ = ""
  ELSE
    Logg$ = Logg$ + LogSymbol$(LWin%) + LogMsg$ + CRLF$
    IF LEN(Logg$) > 960 THEN PUT #10, , Logg$: Logg$ = ""
  END IF
END SUB

