package jp.co.sra.smalltalk.menu;

import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;

import javax.swing.JComponent;
import javax.swing.JMenu;

import jp.co.sra.smalltalk.StSymbol;

/**
 * StMenuViewSwing class
 * 
 *  @author    nisinaka
 *  @created   2005/02/17 (by nisinaka)
 *  @updated   N/A
 *  @version   8.9
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: StMenuViewSwing.java,v 8.10 2008/02/20 06:33:36 nisinaka Exp $
 */
public class StMenuViewSwing extends StMenuItemViewSwing implements StMenuView {

	protected ArrayList menuItemViews = new ArrayList();
	protected WindowListener windowListener = null;

	/**
	 * Create a new instance of StMenuViewSwing and initialize it.
	 *
	 * @param aMenu jp.co.sra.smalltalk.menu.StMenu
	 * @category Instance creation
	 */
	public StMenuViewSwing(StMenu aMenu) {
		super(aMenu);
	}

	/**
	 * Initialize with the window.
	 * This method might be called from addNotify() in some components.
	 * 
	 * @category initialize-releaes
	 */
	protected void initializeWithWindow() {
		if (windowListener != null) {
			return;
		}

		Window aWindow = this.getWindow();
		if (aWindow == null) {
			return;
		}

		windowListener = new WindowAdapter() {
			public void windowClosed(WindowEvent e) {
				StMenuViewSwing.this.release();
			}
		};
		aWindow.addWindowListener(windowListener);
	}

	/**
	 * Remove references to objects that may refer to the receiver.
	 * 
	 * @see jp.co.sra.smalltalk.StObject#release()
	 * @category initialize-release
	 */
	public void release() {
		for (int i = 0; i < menuItemViews.size(); i++) {
			((StMenuItemViewSwing) menuItemViews.get(i)).release();
		}

		super.release();
	}

	/**
	 * Answer my menu.
	 * 
	 * @return jp.co.sra.smalltalk.menu.StMenu
	 * @see jp.co.sra.smalltalk.menu.StMenuView#getMenu()
	 * @category model accessing
	 */
	public StMenu getMenu() {
		return (StMenu) this.getMenuItem();
	}

	/**
	 * Answer the menu item view associated with the given name key (or null if none).
	 * 
	 * @param aSymbol jp.co.sra.smalltalk.StSymbol
	 * @return jp.co.sra.smalltalk.menu.StMenuItemView
	 * @see jp.co.sra.smalltalk.menu.StMenuView#atNameKey_(jp.co.sra.smalltalk.StSymbol)
	 * @category menu items-name keys
	 */
	public StMenuItemView atNameKey_(StSymbol aSymbol) {
		if (menuItemView == null) {
			this.menuItemView(); // to create my menu item view.
		}

		StMenuItemView[] itemViews = (StMenuItemView[]) menuItemViews.toArray(new StMenuItemView[menuItemViews.size()]);
		for (int i = 0; i < itemViews.length; i++) {
			if (itemViews[i].getMenuItem() == StMenu.Separator) {
				// skip 
			} else if (itemViews[i].getMenuItem().nameKey() == aSymbol) {
				return itemViews[i];
			} else if (itemViews[i] instanceof StMenuView) {
				StMenuItemView aMenuItemView = ((StMenuView) itemViews[i]).atNameKey_(aSymbol);
				if (aMenuItemView != null) {
					return aMenuItemView;
				}
			}
		}
		return null;
	}

	/**
	 * Answer the menu item view as JMenu.
	 * 
	 * @return javax.swing.JMenu
	 * @category converting
	 */
	public JMenu toMenu() {
		return (JMenu) this.menuItemView();
	}

	/**
	 * Create a menu item view.
	 * 
	 * @return javax.swing.JComponent
	 * @see jp.co.sra.smalltalk.menu.StMenuItemViewSwing#createMenuItemView()
	 * @category private
	 */
	protected JComponent createMenuItemView() {
		JMenu aMenu = new JMenu();

		StMenuItem[] items = this.getMenu().menuItems();
		for (int i = 0; i < items.length; i++) {
			if (items[i] == StMenu.Separator) {
				aMenu.addSeparator();
			} else {
				StMenuItemViewSwing aMenuItemView = _New(items[i]);
				menuItemViews.add(aMenuItemView);
				aMenu.add(aMenuItemView.toMenuItem());
			}
		}

		return aMenu;
	}

	/**
	 * Set whether the menu is needed to be a light weight one or not.
	 * 
	 * @param aBoolean boolean
	 * @category private
	 */
	public void setLightWeightPopupEnabled(boolean aBoolean) {
		if (menuItemView == null) {
			this.menuItemView(); // to create my menu item view.
		}

		this.toMenu().getPopupMenu().setLightWeightPopupEnabled(aBoolean);

		for (int i = 0; i < menuItemViews.size(); i++) {
			StMenuItemViewSwing aMenuItemView = (StMenuItemViewSwing) menuItemViews.get(i);
			if (aMenuItemView instanceof StMenuViewSwing) {
				((StMenuViewSwing) aMenuItemView).setLightWeightPopupEnabled(aBoolean);
			}
		}
	}

}
