package jp.co.sra.smalltalk.menu;

import java.awt.CheckboxMenuItem;
import java.awt.MenuComponent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import jp.co.sra.smalltalk.DependentEvent;

/**
 * StCheckBoxMenuItemViewAwt class
 * 
 *  @author    nisinaka
 *  @created   2005/02/18 (by nisinaka)
 *  @updated   N/A
 *  @version   8.9
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: StCheckBoxMenuItemViewAwt.java,v 8.9 2008/02/20 06:33:36 nisinaka Exp $
 */
public class StCheckBoxMenuItemViewAwt extends StMenuItemViewAwt implements StCheckBoxMenuItemView {

	/**
	 * Create a new instance of StCheckBoxMenuItemViewAwt and initialize it.
	 *
	 * @param aCheckBoxMenuItem jp.co.sra.smalltalk.StCheckBoxMenuItem
	 * @category Instance creation
	 */
	public StCheckBoxMenuItemViewAwt(StCheckBoxMenuItem aCheckBoxMenuItem) {
		super(aCheckBoxMenuItem);
	}

	/**
	 * Answer my check box menu item.
	 * 
	 * @return jp.co.sra.smalltalk.menu.StCheckBoxMenuItem
	 * @see jp.co.sra.smalltalk.menu.StCheckBoxMenuItemView#getCheckBoxMenuItem()
	 * @category model accessing
	 */
	public StCheckBoxMenuItem getCheckBoxMenuItem() {
		return (StCheckBoxMenuItem) this.getMenuItem();
	}

	/**
	 * Answer the menu item view as CheckboxMenuItem.
	 * 
	 * @return java.awt.CheckboxMenuItem
	 * @category converting
	 */
	public CheckboxMenuItem toCheckboxMenuItem() {
		return (CheckboxMenuItem) this.menuItemView();
	}

	/**
	 * Update for the change notice.
	 * 
	 * @see jp.co.sra.smalltalk.DependentListener#update_(jp.co.sra.smalltalk.DependentEvent)
	 * @category updating
	 */
	public void update_(DependentEvent evt) {
		if (evt.getAspect() == $("selection")) {
			this.updateSelection();
		} else {
			super.update_(evt);
		}
	}

	/**
	 * Update the selection status.
	 * 
	 * @category updating
	 */
	protected void updateSelection() {
		boolean isSelected = this.getCheckBoxMenuItem().isSelected();
		if (this.toCheckboxMenuItem().getState() != isSelected) {
			this.toCheckboxMenuItem().setState(isSelected);
		}
	}

	/**
	 * Update the menu item view.
	 * 
	 * @see jp.co.sra.smalltalk.menu.StMenuItemViewSwing#updateMenuItemView()
	 * @category updating
	 */
	protected void updateMenuItemView() {
		super.updateMenuItemView();
		this.updateSelection();
	}

	/**
	 * Create a menu item view.
	 * 
	 * @return java.awt.MenuComponent
	 * @category private
	 */
	protected MenuComponent createMenuItemView() {
		CheckboxMenuItem aCheckboxMenuItem = new CheckboxMenuItem();
		aCheckboxMenuItem.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				StCheckBoxMenuItemViewAwt aCheckBoxMenuItemView = StCheckBoxMenuItemViewAwt.this;
				boolean isSelected = (e.getStateChange() == ItemEvent.SELECTED);
				if (aCheckBoxMenuItemView.getCheckBoxMenuItem().isSelected() != isSelected) {
					aCheckBoxMenuItemView.getCheckBoxMenuItem().beSelected(isSelected);
					aCheckBoxMenuItemView.performMenu($("selection"), e);
				}
			}
		});
		return aCheckboxMenuItem;
	}

}