package jp.co.sra.smalltalk.menu;

import java.util.ArrayList;

import jp.co.sra.smalltalk.StModel;

/**
 * StAbstractMenuItem class
 * 
 *  @author    nisinaka
 *  @created   2005/02/18 (by nisinaka)
 *  @updated   N/A
 *  @version   8.9
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: StAbstractMenuItem.java,v 8.10 2008/02/20 06:33:36 nisinaka Exp $
 */
public abstract class StAbstractMenuItem extends StModel {

	protected ArrayList menuListeners;

	/**
	 * Answer the menu listeners.
	 * 
	 * @return jp.co.sra.smalltalk.menu.MenuListener[]
	 * @category event handling
	 */
	public synchronized MenuListener[] getMenuListeners() {
		if (menuListeners == null) {
			return new MenuListener[0];
		}
		return (MenuListener[]) menuListeners.toArray(new MenuListener[menuListeners.size()]);
	}

	/**
	 * Add a menu listener.
	 * 
	 * @param aMenuListener jp.co.sra.smalltalk.menu.MenuListener
	 * @category event handling
	 */
	public synchronized void addMenuListener(MenuListener aMenuListener) {
		if (aMenuListener == null || this.menuListeners().contains(aMenuListener)) {
			return;
		}

		this.menuListeners().add(aMenuListener);
	}

	/**
	 * Remove a menu listener.
	 * 
	 * @param aMenuListener jp.co.sra.smalltalk.menu.MenuListener
	 * @category event handling
	 */
	public synchronized void removeMenuListener(MenuListener aMenuListener) {
		if (aMenuListener == null) {
			return;
		}

		this.menuListeners().remove(aMenuListener);
	}

	/**
	 * Perform the menu event.
	 * 
	 * @param aMenuEvent jp.co.sra.smalltalk.menu.MenuEvent
	 * @category event handling
	 */
	public synchronized void performMenu(final MenuEvent aMenuEvent) {
		for (int i = 0; i < this.menuListeners().size(); i++) {
			MenuListener menuListener = (MenuListener) this.menuListeners().get(i);
			menuListener.menuPerformed(aMenuEvent);
		}
	}

	/**
	 * Answer my menu listeners.
	 * 
	 * @return java.util.ArrayList
	 * @category private
	 */
	protected ArrayList menuListeners() {
		if (menuListeners == null) {
			menuListeners = new ArrayList();
		}
		return menuListeners;
	}

}