package jp.co.sra.smalltalk.menu;

import java.util.EventObject;

import jp.co.sra.smalltalk.StSymbol;

/**
 * MenuEvent class
 * 
 *  @author    nisinaka
 *  @created   2005/02/18 (by nisinaka)
 *  @updated   N/A
 *  @version   8.9
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: MenuEvent.java,v 8.10 2008/02/20 06:33:36 nisinaka Exp $
 */
public class MenuEvent extends EventObject {

	protected StSymbol aspect;
	protected Object parameter;

	/**
	 * Create a new instance of MenuEvent and initialize it.
	 *
	 * @param source jp.co.sra.smalltalk.menu.StMenuItemView
	 * @param aspect jp.co.sra.smalltalk.StSymbol
	 * @category Instance creation
	 */
	public MenuEvent(StMenuItemView source, StSymbol aspect) {
		this(source, aspect, null);
	}

	/**
	 * Create a new instance of MenuEvent and initialize it.
	 *
	 * @param source jp.co.sra.smalltalk.menu.StMenuItemView
	 * @param aspect jp.co.sra.smalltalk.StSymbol
	 * @param parameter java.lang.Object
	 * @category Instance creation
	 */
	public MenuEvent(StMenuItemView source, StSymbol aspect, Object parameter) {
		super(source);
		this.aspect = aspect;
		this.parameter = parameter;
	}

	/**
	 * Answer the menu item as a source of the event.
	 * 
	 * @return jp.co.sra.smalltalk.menu.StMenuItem
	 * @category accessing
	 */
	public StMenuItem getMenuItem() {
		return (this.getMenuItemView() == null) ? null : this.getMenuItemView().getMenuItem();
	}

	/**
	 * Answer the menu item view as a source of the event.
	 * 
	 * @return jp.co.sra.smalltalk.menu.StMenuItemView
	 * @category accessing
	 */
	public StMenuItemView getMenuItemView() {
		return (StMenuItemView) this.getSource();
	}

	/**
	 * Answer the aspect of the event.
	 * 
	 * @return jp.co.sra.smalltalk.StSymbol
	 * @category accessing
	 */
	public StSymbol getAspect() {
		return aspect;
	}

	/**
	 * Answer the parameter of the event.
	 * Typically is the original event, ActionEvent or ItemEvent.
	 * 
	 * @return jp.co.sra.smalltalk.StSymbol
	 * @category accessing
	 */
	public Object getParameter() {
		return parameter;
	}

	/**
	 * Returns a String representation of this MenuEvent.
	 *
	 * @return java.lang.String
	 * @category printing
	 */
	public String toString() {
		return this.getClass().getName() + "[source=" + source + ",aspect=" + aspect + ",parameter=" + parameter + "]";
	}

}