package jp.co.sra.smalltalk;

import java.awt.*;
import java.io.*;
import java.net.*;

/**
 * SystemResourceSupport class
 * 
 *  @author    Hirotsugu Kondo
 *  @created   1998/12/04 (by Hirotsugu Kondo)
 *  @updated   2002/04/26 (by Mitsuhiro Asada)
 *  @version   8.9
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: SystemResourceSupport.java,v 8.10 2008/02/20 06:33:18 nisinaka Exp $
 */
public class SystemResourceSupport {
	protected static Frame systemFrame;
	protected static Window systemWindow;

	static {
		Initialize();
	}

	/**
	 * Create a new instance of <code>SystemResourceSupport</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public SystemResourceSupport() {
	}

	/**
	 * Answer the bounds that represents the text which read from a reader.
	 * 
	 * @param reader java.io.BufferedReader
	 * @param font java.awt.font
	 * @return java.awt.Point
	 * @category Utilities
	 */
	public static Point _getStringExtentFor_(BufferedReader reader, Font font) {
		FontMetrics fontMetrics = getFontMetrics(font);
		Point extent = new Point(0, 0);
		try {
			String line = null;
			while ((line = reader.readLine()) != null) {
				Point point = new Point(fontMetrics.stringWidth(line), fontMetrics.getHeight());
				extent = new Point(Math.max(extent.x, point.x), extent.y + point.y);
			}
		} catch (IOException e) {
			System.out.println("Exception: " + e.getMessage());
			e.printStackTrace();
			extent = null;
		}

		return extent;
	}

	/**
	 * Answer the bounds that represents the string.
	 * 
	 * @param string java.lang.String
	 * @param font java.awt.Font
	 * @return java.awt.Point
	 * @category Utilities
	 */
	public static Point _getStringExtentFor_(String string, Font font) {
		FontMetrics fontMetrics = getFontMetrics(font);

		return new Point(fontMetrics.stringWidth(string), fontMetrics.getHeight());
	}

	/**
	 * Answer a new image. replaced by <code>StImage(int, int)</code>.
	 * 
	 * @param width int
	 * @param height int
	 * @return java.awt.Image
	 * @deprecated since StPL41
	 * @category Image utilities
	 */
	public static Image createImage(int width, int height) {
		return getWindow().createImage(width, height);
	}

	/**
	 * Answer a new image. replaced by <code>StImage(int, int)</code>.
	 * 
	 * @param extent java.awt.Dimension
	 * @return java.awt.Image
	 * @deprecated since StPL41
	 * @category Image utilities
	 */
	public static Image createImage(Dimension extent) {
		return createImage(extent.width, extent.height);
	}

	/**
	 * Answer a new image. replaced by <code>StImage(int, int)</code>.
	 * 
	 * @param extent java.awt.Point
	 * @return java.awt.Image
	 * @deprecated since StPL41
	 * @category Image utilities
	 */
	public static Image createImage(Point extent) {
		return createImage(extent.x, extent.y);
	}

	/**
	 * Answer an image from resourceName.
	 * 
	 * @param resourceName java.lang.String
	 * @return java.awt.Image
	 * @category Image utilities
	 */
	public static Image createImage(String resourceName) {
		try {
			Class aClass = Class.forName("jp.co.sra.smalltalk.SystemResourceSupport");
			URL url = aClass.getResource(resourceName);

			return createImage(url);
		} catch (Exception e) {
			System.out.println("Exception: " + e.getMessage());
			e.printStackTrace();
		}

		return null;
	}

	/**
	 * Answer an image from url.
	 * 
	 * @param url java.net.URL
	 * @return java.awt.Image
	 * @category Image utilities
	 */
	public static Image createImage(URL url) {
		try {
			Frame frame = new Frame();
			Toolkit toolKit = frame.getToolkit();
			Image image = toolKit.getImage(url);
			MediaTracker mt = new MediaTracker(frame);

			mt.addImage(image, 0);

			try {
				mt.waitForAll();
			} catch (InterruptedException e) {
				System.err.println("image load interrupted.");

				return null;
			}

			int status = mt.statusAll(false);

			if (((status & MediaTracker.ABORTED) != 0) || ((status & MediaTracker.ERRORED) != 0)) {
				System.err.println("could not load image.");

				return null;
			}

			return image;
		} catch (Exception e) {
			System.out.println("Exception: " + e.getMessage());
			e.printStackTrace();
		}

		return null;
	}

	/**
	 * Answer the default font.
	 * 
	 * @return Font
	 * @category Font utilities
	 */
	public static Font getFont() {
		return getWindow().getFont();
	}

	/**
	 * Answer the instance of <code>FontMetrics</code> with the specified font.
	 * 
	 * @param aFont DOCUMENT ME!
	 * @return FontMetrics
	 * @category Font utilities
	 */
	public static FontMetrics getFontMetrics(Font aFont) {
		Font font = aFont;

		if (font == null) {
			font = getFont();
		}

		return getWindow().getFontMetrics(font);
	}

	/**
	 * Answer the instance of <code>Frame</code>.
	 * 
	 * @return java.awt.Frame
	 * @category Utilities
	 */
	public static Frame getFrame() {
		return systemFrame;
	}

	/**
	 * Answer the instance of <code>Graphics</code>.
	 * 
	 * @return Graphics
	 * @category Utilities
	 */
	public static Graphics getGraphics() {
		return getWindow().getGraphics();
	}

	/**
	 * Answer the instance of <code>Window</code>.
	 * 
	 * @return java.awt.Window
	 * @category Utilities
	 */
	public static Window getWindow() {
		return systemWindow;
	}

	/**
	 * Initialize the class.
	 * 
	 * @category Class initialization
	 */
	protected static void Initialize() {
		systemFrame = new Frame();
		systemWindow = new Window(systemFrame);
		systemWindow.pack();
		systemWindow.setVisible(true);
		systemWindow.setVisible(false);
	}
}
