package jp.co.sra.smalltalk;

/**
 * StValueHolderTestExamples class
 * 
 *  @author    nisinaka
 *  @created   1998/10/xx (by nisinaka)
 *  @updated   N/A
 *  @version   8.9
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: StValueHolderTestExamples.java,v 8.10 2008/02/20 06:33:18 nisinaka Exp $
 */
public class StValueHolderTestExamples extends SmalltalkTestExamples {

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		final StValueHolder a = new StValueHolder(null);

		a.compute_(new StBlockClosure() {
			public Object value() {
				System.out.println("a = " + a.value().toString());

				return null;
			}
		});
		a.value_("Smalltalk");
		a.value_("Aoki");

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		final StValueHolder a = new StValueHolder(null);

		a.onChangeSend_to_("value", new StBlockClosure() {
			public Object value() {
				System.out.println("a = " + a.value().toString());

				return null;
			}
		});
		a.value_("Smalltalk");
		a.value_("Aoki");

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		StValueHolder a = new StValueHolder(1);

		a.compute_(new StBlockClosure() {
			public Object value_(Object v) {
				System.out.println("a = " + v.toString());

				return null;
			}
		});

		StValueHolder b = new StValueHolder(1);

		b.compute_(new StBlockClosure() {
			public Object value_(Object v) {
				System.out.println("b = " + v.toString());

				return null;
			}
		});

		StBlockClosure aBlock = new StBlockClosure() {
			public Object value_value_(Object va, Object vb) {
				return new Integer(((Integer) va).intValue() * ((Integer) vb).intValue());
			}
		};

		StValueHolder[] anArray = { a, b };
		StBlockValue ab = new StBlockValue(aBlock, anArray);

		ab.compute_(new StBlockClosure() {
			public Object value_(Object v) {
				System.out.println("ab = " + v.toString());

				return null;
			}
		});
		a.value_(10);
		b.value_(20);

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args an array of command-line arguments
	 * @category Main
	 */
	public static void main(java.lang.String[] args) {
		new StValueHolderTestExamples();
	}
}
