package jp.co.sra.smalltalk;

import java.awt.Point;

/**
 * StRectangleTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2002/10/28 (by nisinaka)
 *  @updated   N/A
 *  @version   8.9
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: StRectangleTestExamples.java,v 8.10 2008/02/20 06:33:18 nisinaka Exp $
 */
public class StRectangleTestExamples extends SmalltalkTestExamples {

	/**
	 * Example1
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		StRectangle aRectangle = new StRectangle(0, 0, 100, 100);
		System.out.println(aRectangle.insetBy_(1));
		return true;
	}

	/**
	 * Example2
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		StRectangle aRectangle = new StRectangle(0, 0, 100, 100);
		System.out.println(aRectangle.insetBy_(new Point(1, 2)));
		return true;
	}

	/**
	 * Example3
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		StRectangle aRectangle = new StRectangle(0, 0, 100, 100);
		System.out.println(aRectangle.insetBy_(new StRectangle(1, 2, 3, 4)));
		return true;
	}

	/**
	 * Example4
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example4() {
		StRectangle aRectangle = new StRectangle(0, 0, 100, 100);
		System.out.println(aRectangle.expandedBy_(1));
		return true;
	}

	/**
	 * Example5
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example5() {
		StRectangle aRectangle = new StRectangle(0, 0, 100, 100);
		System.out.println(aRectangle.expandedBy_(new Point(1, 2)));
		return true;
	}

	/**
	 * Example6
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example6() {
		StRectangle aRectangle = new StRectangle(0, 0, 100, 100);
		System.out.println(aRectangle.expandedBy_(new StRectangle(1, 2, 3, 4)));
		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new StRectangleTestExamples();
	}
}
