package jp.co.sra.smalltalk;

import java.util.Vector;

/**
 * StModel class
 * 
 *  @author    nisinaka
 *  @created   1998/08/05 (by nisinaka)
 *  @updated   1998/10/09 (by nisinaka)
 *  @updated   2006/10/04 (by nisinaka)
 *  @version   8.9
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: StModel.java,v 8.10 2008/02/20 06:33:18 nisinaka Exp $
 */
public class StModel extends StObject {

	protected Vector dependents = null;

	/**
	 * Convert the receiver's dependents as an array of StObject.
	 * 
	 * @return jp.co.sra.smalltalk.StObject[]
	 * @category private
	 */
	public StObject[] _dependentsAsArray() {
		if (dependents == null) {
			return null;
		}

		int size = dependents.size();
		StObject[] anArray = new StObject[size];
		dependents.copyInto(anArray);
		return anArray;
	}

	/**
	 * Answer the receiver's dependents.
	 * 
	 * @return java.util.Vector
	 * @see jp.co.sra.smalltalk.StObject#myDependents()
	 * @category private
	 */
	public Vector myDependents() {
		return dependents;
	}

	/**
	 * Set the receiver's dependents.
	 * 
	 * @param dependentsOrNull java.util.Vector
	 * @see jp.co.sra.smalltalk.StObject#myDependents_(java.util.Vector)
	 * @category private
	 */
	public void myDependents_(Vector dependentsOrNull) {
		dependents = dependentsOrNull;
	}

	/**
	 * Do not copy the dependents list.
	 * 
	 * @return jp.co.sra.smalltalk.StObject
	 * @see jp.co.sra.smalltalk.StObject#postCopy()
	 * @category copying
	 */
	public StObject postCopy() {
		super.postCopy();
		this.breakDependents();
		return this;
	}

}
